<?php
/**
 * Functions
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 685; /* pixels */

/**
 * Set up theme (Child Theme Support)
 *
 * @since Orbit 1.1.0
 */
if ( ! function_exists( 'orbit_setup') ) {

	/**
	 * Set up theme defaults and registers support for various WordPress features.
	 *
	 * @since Orbit 1.0.0
	 */
	function orbit_setup() {

		//	For translation/localization support.
		load_theme_textdomain( 'orbit', get_template_directory() .'/languages' );

		// Add default posts and comments RSS feed links to <head>.
		add_theme_support( 'automatic-feed-links' );

		// Add support orb-plus plugin for shortcodes
		add_theme_support( 'orb-plus' );

		// This theme uses Featured Images (also known as post thumbnails) for per-post/per-page Custom Header images
		add_theme_support( 'post-thumbnails' );

		// Arguments for Custom Background
		$background_args = array(
			'default-color' => 'f6f6f6',
			'default-image' => '',
		);

		$background_args = apply_filters( 'orbit_custom_background_args', $background_args );
		
		// Add support for custom backgrounds.
		add_theme_support( 'custom-background', $background_args );

		// Arguments for Custom Header
		$header_args = array( 
			'default-image' => get_template_directory_uri() . '/images/default-logo.png',
			'width'			=> 240,
			'height'		=> 72,
			'flex-width'	=> true,
			'flex-height'	=> true,
			'header-text'	=> false
		);

		$header_args = apply_filters( 'orbit_custom_header_args', $header_args );

		// Add theme support for Custom Header
		add_theme_support( 'custom-header', $header_args );

		// Arguments for Menus
		$menus_args = array(
			'header-menu' => __( 'Header Menu', 'orbit' ),
		);

		$menus_args = apply_filters( 'orbit_custom_menus_args', $menus_args );

		// Add support for custom menus.
		register_nav_menus( $menus_args );

		// Add callback for custom TinyMCE editor stylesheets. (editor-style.css)
		add_editor_style();

		// Add support for title From WordPress 4.4
		add_theme_support( 'title-tag' );
				
		// Load helper functions for theme.
		require( get_template_directory() . '/inc/theme-helper.php' );

		// Load settings functions for theme.
		require( get_template_directory() . '/inc/theme-settings.php' );

		// Load sanitize theme options.
		require( get_template_directory() . '/inc/theme-sanitize.php' );

		// Load up our theme options page and related code.
		require( get_template_directory() . '/inc/theme-options.php' );

		// Load up our theme customize options.
		require( get_template_directory() . '/inc/theme-customize.php' );

		// Load up our theme options to custom style.
		require( get_template_directory() . '/inc/theme-insert-options.php' );

		// Load up our theme hooks.
		require( get_template_directory() . '/inc/theme-hooks.php' );

	}
}
add_action( 'after_setup_theme', 'orbit_setup' );

/**
 * Register our sidebars and widgetized areas.
 *
 * @since Orbit 1.0.0
 */
function orbit_widgets_init() {

	register_sidebar( array(
		'name' => __( 'Main Sidebar', 'orbit' ),
		'description' => __( 'Main sidebar - sidebar.php', 'orbit' ),
		'id' => 'main-sidebar',
		'before_widget' => '<div id="%1$s" class="aside-box %2$s">',
		'after_widget' => '</div> <!-- end widget aside-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	) );

	register_sidebar( array(
		'name' => __( 'Second Sidebar', 'orbit' ),
		'description' => __( 'Sidebar in template page-two.php - sidebar-two.php', 'orbit' ),
		'id' => 'second-sidebar',
		'before_widget' => '<div id="%1$s" class="aside-box %2$s">',
		'after_widget' => '</div> <!-- end widget aside-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	) );

	register_sidebar( array(
		'name' => __( 'Front Sidebar', 'orbit' ),
		'description' => __( 'Front in template front-page.php - sidebar-front.php', 'orbit' ),
		'id' => 'front-sidebar',
		'before_widget' => '<div id="%1$s" class="aside-box %2$s">',
		'after_widget' => '</div> <!-- end widget aside-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	) );

	register_sidebar( array(
		'name' => __( 'Front Box 1', 'orbit' ),
		'description' => __( 'First box in front page - front-page.php', 'orbit' ),
		'id' => 'front-box-1',
		'before_widget' => '<div id="%1$s" class="widget-front-box %2$s">',
		'after_widget' => '</div> <!-- end widget-front-box -->',
		'before_title' => '<h2>',
		'after_title' => '</h2>',
	));

	register_sidebar( array(
		'name' => __( 'Front Box 2', 'orbit' ),
		'description' => __( 'Second box in front page - front-page.php', 'orbit' ),
		'id' => 'front-box-2',
		'before_widget' => '<div id="%1$s" class="widget-front-box %2$s">',
		'after_widget' => '</div> <!-- end widget-front-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));

	register_sidebar( array(
		'name' => __( 'Front Box 3', 'orbit' ),
		'description' => __( 'Third box in front page - front-page.php', 'orbit' ),
		'id' => 'front-box-3',
		'before_widget' => '<div id="%1$s" class="widget-front-box %2$s">',
		'after_widget' => '</div> <!-- end widget-front-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));

	register_sidebar( array(
		'name' => __( 'Footer Box 1', 'orbit' ),
		'description' => __( 'First box in footer - footer.php', 'orbit' ),
		'id' => 'footer-box-1',
		'before_widget' => '<div id="%1$s" class="widget-footer-box %2$s">',
		'after_widget' => '</div> <!-- end widget-footer-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));

	register_sidebar( array(
		'name' => __( 'Footer Box 2', 'orbit' ),
		'description' => __( 'Second box in footer - footer.php', 'orbit' ),
		'id' => 'footer-box-2',
		'before_widget' => '<div id="%1$s" class="widget-footer-box %2$s">',
		'after_widget' => '</div> <!-- end widget-footer-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));

	register_sidebar( array(
		'name' => __( 'Footer Box 3', 'orbit' ),
		'description' => __( 'Third box in footer - footer.php', 'orbit' ),
		'id' => 'footer-box-3',
		'before_widget' => '<div id="%1$s" class="widget-footer-box %2$s">',
		'after_widget' => '</div> <!-- end widget-footer-box -->',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
}
add_action( 'widgets_init', 'orbit_widgets_init' );

/**
 * A safe way of adding JavaScripts to a WordPress generated page.
 *
 * @since Orbit 1.0.0
 */
function orbit_script_enqueuer() {
	global $post;

	// Style for orbit theme
	wp_enqueue_style( 'orbit-style', get_stylesheet_uri() );

	// Fonts from google
	$orbit_options = orbit_get_theme_options();
	
	if ( $orbit_options['google_font_title'] != '' ) {
		
		$style_google_font_title = '//fonts.googleapis.com/css?family=' . esc_attr( $orbit_options['google_font_title'] );
		$style_google_font_title = apply_filters( 'style_google_font_title', $style_google_font_title );

		wp_enqueue_style( 'FontTitle', $style_google_font_title );
	}
	
	if ( $orbit_options['google_font_base']	 != '' ) {
		
		$style_google_font_base = '//fonts.googleapis.com/css?family=' . esc_attr( $orbit_options['google_font_base'] );
		$style_google_font_base = apply_filters( 'style_google_font_base', $style_google_font_base );
		
		wp_enqueue_style( 'FontGeneral', $style_google_font_base );
	}

	// Arguments for slug page to load flexslider
	$flexslider_pages_args = array();
	
	$flexslider_pages_args = apply_filters( 'orbit_flexslider_pages_args', $flexslider_pages_args );

	// flexslider only in front-page and flexslider_pages_args array
	if ( ! is_search() ) {
		if ( is_front_page() || in_array( $post->post_name, $flexslider_pages_args ) ) { 
			wp_enqueue_script( 'orbit-slider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array( 'jquery' ), '', false);
		}
	}

	wp_enqueue_style( 'dashicons' );
	wp_enqueue_script( 'orbit-navigation-2', get_template_directory_uri() . '/js/responsive-nav.js', array( 'jquery' ), '0.1', false );

	// Comment reply function
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'orbit_script_enqueuer' );
?>