<?php
/**
 * Front Page template
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>
<?php if ( 'posts' == get_option( 'show_on_front' ) ) {
     get_template_part( 'index' );
} else { ?>

<?php get_header(); ?>

	<div class="front-features">
		<div id="front-text-feature">
			<h1>
				<?php $options = orbit_get_theme_options();
					if ( $options['front_page_header'] ) {
						echo $options['front_page_header'];
					} else {
						_e( 'Orbit Free Theme', 'orbit' );
					}
				?>
			</h1>
			<h2>
				<?php
					if ( $options['front_page_subheader'] ) {
						echo $options['front_page_subheader'];
					} else {
						_e( 'Responsive Theme for WordPress', 'orbit' );
					}
				?>
			</h2>
			<div class="front-phrase">
				<?php
					if ( $options['front_page_textarea'] ) {
						echo $options['front_page_textarea'];
					} else {
						_e('<p>Title, Subtitle, Long text, "Call to Action" button and image slider are editable in:</p> <strong>Appearance &raquo; Orbit Options &raquo; Front Page Options</strong></p>', 'orbit');
					}
				?>
			</div>
			<div class="front-call-to-action">
				<a class="front-button" href="<?php echo esc_url( $options['url_call_to_action'] ); ?>" >
					<?php if ( $options['front_page_call_to_action'] ) {
						echo $options['front_page_call_to_action'];
					} else {
						_e( 'Call to action', 'orbit' );
					}
					?>
				</a>
			</div>

		</div> <!-- end front-text-feature -->

		<div id="front-slide">

			<?php bit_slider(); ?>
			
			<?php orbit_render_slider(); ?>

			<?php bit_slider_end(); ?>
			
		</div> <!-- end front-slide -->
	</div>

	<div id="front-boxes">
		
		<?php bit_front_boxes_start(); ?>

		<?php orbit_render_front_boxes(); ?>

		<?php bit_front_boxes_end(); ?>
		
	</div> <!-- end front-boxes -->

	<?php if ( $options['show_posts'] > 0 ) : ?>

	<div id="front-posts">
	
		<?php if ( is_active_sidebar( 'front-sidebar' ) ) $class_front = 'front-posts-sidebar'; else $class_front = 'front-posts-full';?>
	
		<div class="<?php echo $class_front; ?>">
			<?php $front_posts = new WP_Query( apply_filters( 'front_posts', array( 'showposts' => $options['show_posts'], 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) ); ?>
				
			<?php if ( $front_posts->have_posts() ) : while ( $front_posts->have_posts() ) : $front_posts->the_post(); ?>

				<?php get_template_part( 'content', 'excerpt' ); ?>
								
			<?php endwhile; ?>
				
				<div class="navigation">

					<span class="previous-post"><a href="<?php echo get_page_link( get_option( 'page_for_posts' ) ); ?>"><?php  _e( 'Show all posts', 'orbit' ); ?></a></span>

				</div><!-- end of .navigation -->

			<?php else : ?>

				<article>
					<h1 class=""><?php _e( 'Oops, Post Not Found!', 'orbit' ); ?></h1>
				</article>

			<?php endif; ?>

		</div>		
		
		<?php if ( is_active_sidebar( 'front-sidebar' ) ) : ?>
		
			<?php get_sidebar( 'front' ) ?>
		
		<?php endif; ?>

	</div>
	<?php endif; ?>
	
	<?php get_footer(); ?>
	
<?php } ?>