<?php
/**
 * The template for displaying the footer.
 *
 * Contains footer content and the closing of the
 * content-container and main-container div elements.
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

	</div>	<!-- end content-container -->

	<?php bit_content_container_end(); // after closing 'content-container' hook ?>

	<footer id="main-footer">

		<div class="footer-boxes">

			<div class="footer-box">
				<?php if (!dynamic_sidebar( 'footer-box-1' ) ) : ?>
					<div class="footer-menu">
						<h2><?php _e( 'Orbit', 'orbit' ); ?></h2>
						<ul class="footer-nav">
							<li><a href="#"><?php _e( 'About Us', 'orbit' ); ?></a></li>
							<li><a href="#"><?php _e( 'Contact', 'orbit' ); ?></a></li>
							<li><a href="#"><?php _e( 'Support', 'orbit' ); ?></a></li>
						</ul>
						<p><strong><?php _e( 'Widget Area "Footer Box 1"', 'orbit' ); ?></strong></p>
					</div>
				<?php endif ?>
			</div> <!-- end footer-box 1 -->

			<div class="footer-box">
				<?php if (!dynamic_sidebar( 'footer-box-2' ) ) : ?>
					<h2><?php _e( 'Last Posts', 'orbit' ); ?></h2>
					<ul>
						<li><a href="#"><?php _e( 'New Service Launched', 'orbit' ); ?></a></li>
						<li><a href="#"><?php _e( 'My First Post', 'orbit' ); ?></a></li>
						<li><a href="#"><?php _e( 'Hello world!', 'orbit' ); ?></a></li>
					</ul>
					<p><strong><?php _e( 'Widget Area "Footer Box 2"', 'orbit' ); ?></strong></p>
				<?php endif ?>
			</div> <!-- end footer-box 2 -->

			<div class="footer-box">
				<?php if (!dynamic_sidebar( 'footer-box-3' ) ) : ?>
					<h2><?php _e( 'Contact', 'orbit' ); ?></h2>
					<p><?php _e( 'Constitution Hill, London', 'orbit' ); ?></p>
					<p><?php _e( 'Phone', 'orbit' ); ?> <strong>+62 12345689</strong>, Fax <strong>+62 12345689</strong></p>
					<p>Email <strong>support@localhost.com</strong></p>
					<p><strong><?php _e( 'Widget Area "Footer Box 3"', 'orbit' ); ?></strong></p>
				<?php endif ?>
			</div> <!-- end footer-box 3 -->

		</div>

		<div class="footer-extra">
			<div class="footer-copy">
				<?php $footer_info = orbit_get_theme_options( 'footer_info' );;
					if ( !$footer_info ) {
						echo '&copy; ' . date('Y') . ' ';
						echo bloginfo( 'name' );
					} else {
						echo $footer_info;
					}
				?>
			</div>
			<div class="footer-credit">
				<?php bit_footer_credit(); ?>
			</div>
		</div>

	</footer>
</div> <!-- end main-container -->
<?php bit_main_container_end(); // after main-container hook ?>

<?php wp_footer(); ?>
</body>
</html>