<?php
/**
 * The template used for displaying page content in page.php, second-page.php and full-width-page.php
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

			<header class="article-header <?php if ( !orbit_show_title_page() ) echo 'display-hidden'; ?>">
				<h1><?php the_title(); ?></h1>
			</header>

			<?php if ( has_post_thumbnail() ) : ?>
				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" >
					<?php the_post_thumbnail(); ?>
				</a>
			<?php endif; ?>

			<?php the_content(); ?>

			<?php wp_link_pages( array( 'before' => '<p class="page-links">' . __( 'Pages:', 'orbit' ), 'after' => '</p>' ) ); ?>

			<?php edit_post_link( __( 'Edit', 'orbit' ), '<p class="edit-link">', '</p> ' ); ?>

			<?php comments_template( '', true ); ?>

		</article>