<?php
/**
 * The default template for displaying excerpt.
 * Used for index, archive, search, author, category and tag
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<header class="article-header">
				<h1><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
				<p class="article-meta"><time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time>
					<?php $options = orbit_get_theme_options();
						if ( $options['show_author'] ){
							echo ' ' . __( 'by', 'orbit' ) . ' <a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" >' . get_the_author() . '</a>';
						}
						if ( $options['show_categories'] ){
							_e( ' | Categories: ', 'orbit' ); the_category( ', ' );
						}
						if ( $options['show_tags'] ){
							the_tags( __( ' | Tags: ', 'orbit' ), ', ' );
						}
					?>
					<?php edit_post_link( __( 'Edit', 'orbit' ), '<span class="edit-link"> | ', '</span>' ); ?>
					<?php
						if ( comments_open() ) :
							echo '<span class="comment-link-meta">';
							comments_popup_link(__('No Comments &darr;', 'orbit'), __('1 Comment &darr;', 'orbit'), __('% Comments &darr;', 'orbit'));
							 echo '</span>';
						endif;
					?>
				</p> <!-- end article-meta -->
			</header>
			<?php if ( has_post_thumbnail()) : ?>
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
					<?php the_post_thumbnail(); ?>
				</a>
			<?php endif; ?>

			<?php if ( is_home() ) : ?>
				<?php the_content( '<span class="more-link">' . __( 'Read more &#8250;', 'orbit' ) . '</span>' ); ?>
			<?php else : ?>
				<?php the_excerpt(); ?>
			<?php endif; ?>

			<footer class="article-footer">
				<?php wp_link_pages( array( 'before' => '<p class="page-links">' . __( 'Pages:', 'orbit' ), 'after' => '</p>' ) ); ?>
			</footer>	
		</article><!-- end excerpt article -->
		
		<?php bit_excerpt_end(); ?>
		