<?php
/**
 * The default template for displaying content. Used for single
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<header class="article-header">
				<h1><?php the_title(); ?></h1>
				<p class="article-meta"><time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time>
					<?php $options = orbit_get_theme_options();
						if ( $options['show_author'] ){
							echo ' ' . __( 'by', 'orbit' ) . ' <a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" >' . get_the_author() . '</a>';
						}
						if ( $options['show_categories'] ){
							_e( ' | Categories: ', 'orbit' ); the_category( ', ' );
						}
						if ( $options['show_tags'] ){
							the_tags( __( ' | Tags: ', 'orbit' ), ', ' );
						}
					?>
					<?php edit_post_link( __( 'Edit', 'orbit' ), '<span class="edit-link"> | ', '</span>' ); ?>
					<?php
						if ( comments_open() ) :
							echo '<span class="comment-link-meta">';
							comments_popup_link(__('No Comments &darr;', 'orbit'), __('1 Comment &darr;', 'orbit'), __('% Comments &darr;', 'orbit'));
							echo '</span>';
						endif;
					?>
				</p> <!-- end article-meta -->
			</header>
			<?php if ( has_post_thumbnail()) : ?>
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
					<?php the_post_thumbnail(); ?>
				</a>
			<?php endif; ?>
			<?php the_content(); ?>

			<footer class="article-footer">
				<?php wp_link_pages( array( 'before' => '<p class="page-links">' . __( 'Pages:', 'orbit' ), 'after' => '</p>' ) ); ?>
			</footer>
			<?php comments_template( '', true ); ?>
		</article><!-- end post article -->

		<?php bit_post_end(); ?>
				
		<div class="navigation">
			<span class="previous-post"><?php previous_post_link( '%link', __( '&#8249; Previous', 'orbit' ) ); ?></span>
			<span class="next-post"><?php next_post_link( '%link', __( 'Next &#8250;', 'orbit' ) ); ?></span>
		</div>