<?php
/**
 * The template for displaying Author Archive pages.
 *
 * Used to display archive-type pages for posts by an author.
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

	<?php get_header(); ?>

	<?php orbit_get_sidebar( 'left' ) ?>

	<div id="content" class="content-index">

		<?php if ( have_posts() ): the_post(); ?>

			<?php if ( get_the_author_meta( 'description' ) ) : ?>
				<div class="author-info">
					<div class="author-avatar">
						<?php echo get_avatar( get_the_author_meta( 'user_email' ) ); ?>
					</div><!-- .author-avatar -->
					<div class="author-description">
						<h2><?php echo __( 'About', 'orbit' ) . ' ' . get_the_author() ; ?></h2>
						<p><?php the_author_meta( 'description' ); ?></p>
					</div><!-- .author-description	-->
				</div><!-- .author-info	-->
			<?php endif; ?>
						
		<?php rewind_posts(); ?>

		<?php while ( have_posts() ) : the_post(); ?>
			<?php get_template_part( 'content', 'excerpt' ); ?>

		<?php endwhile; ?>
			<?php get_template_part( 'content', 'navigation' ); ?>

		<?php else : ?>

			<article>
				<h1 class=""><?php _e( 'Oops, Post Not Found!', 'orbit' ); ?></h1>
			</article>

		<?php endif; ?>

	</div>	<!-- end content -->

	<?php orbit_get_sidebar( 'rigth' ) ?>

	<?php get_footer(); ?>