<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php wp_title(); ?></title>
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_head(); ?>
</head>
<body <?php body_class()?>>
    <div id="root">
        <div id="header">
            <div id="logo">
                <?php if ('blank' !== get_header_textcolor()) : ?>
                    <h1><a href="<?php echo esc_url(home_url()); ?>"><?php bloginfo('name'); ?></a></h1>
                    <div class="description"><?php bloginfo('description'); ?></div>
                <?php endif; ?>
            </div>
            <div id="nav-container">
                <div id="over-nav-line"></div>
                <div id="navigation">
                    <?php wp_nav_menu(array('menu' => 'Header Navigation' , 'container_class' => 'menu-header', 'theme_location' => 'main', 'depth' => 1)); ?>
                </div>
            </div>
            <div id="right-container"></div>
		<?php get_search_form() ?>
        </div><!--#header-->
        <div id="main">
            <div class="lines">
