<?php

function orangetechno_after_setup_theme() {

    global $content_width;

    if (!isset($content_width)) {
        $content_width = 537;
    }

    add_editor_style('editor-style.css');

    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('custom-header', array(
        'width'               => 515,
        'height'              => 170,
        'default-text-color'  => '000000',
        'wp-head-callback'    => 'orangetechno_header_style',
    ));
    add_theme_support('custom-background', array(
        'wp-head-callback' => 'orangetechno_custom_background',
    ));
    add_theme_support('html5');

    register_nav_menu('main', 'Main navigation menu');
}
add_action('after_setup_theme', 'orangetechno_after_setup_theme');

function orangetechno_custom_background() {
    /* Get the background image. */
    $image = get_background_image();
    /* If there's an image, just call the normal WordPress callback. We won't do anything here. */
    if ( !empty( $image ) ) {
            _custom_background_cb();
            return;
    }
    /* Get the background color. */
    $color = get_background_color();
    /* If no background color, return. */
    if ( empty( $color ) )
            return;
    /* Use 'background' instead of 'background-color'. */
    $style = "background: #{$color};";
?>
<style type="text/css">body { <?php echo trim( $style ); ?> }</style>
<?php
}

add_action( 'widgets_init', 'orangetechno_widgets_init' );
function orangetechno_widgets_init() {
    register_sidebar( array(
        'name'          => 'Sidebar',
        'id'            => 'sidebar',
        'description'   => 'Right Sidebar',
        'before_title'  =>'<h3>',
        'after_title'   =>'</h3>',
        'before_widget' =>'<div class="box">',
        'after_widget'  =>'</div>'
    ) );
}



function orangetechno_wp_enqueue_scripts() {

    wp_register_style('orangetechno-print', get_template_directory_uri().'/print.css', '', 'false', 'print');
    wp_register_style('orangetechno-ie', get_template_directory_uri().'/ie.css');
    $GLOBALS['wp_styles']->add_data( 'orangetechno-ie', 'conditional', 'lte IE 8' );

    wp_enqueue_style( 'orangetechno-print');

    wp_enqueue_style( 'orangetechno-ie');

    wp_enqueue_style( 'orangetechno_style', get_stylesheet_uri());

    if ( is_singular() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'orangetechno_wp_enqueue_scripts' );



function orangetechno_header_style() {
    if (get_header_image() != '') {
    ?><style type="text/css">
        #headerimg {
           text-align: right;
           background: url(<?php header_image(); ?>) no-repeat;
	       margin-bottom: 20px;
        }
    </style><?php
    } else {
    ?><style type="text/css">
        #headerimg {
	    display:none;
        }
    </style><?php
    }
}

function orangetechno_remove_width_attribute( $html ) {
   $html = preg_replace( '/(width|height)="\d*"\s/', "", $html );
   return $html;
}
add_filter( 'post_thumbnail_html', 'orangetechno_remove_width_attribute', 10 );
add_filter( 'image_send_to_editor', 'orangetechno_remove_width_attribute', 10 );

function orangetechno_wp_title( $title, $sep ) {
    global $paged, $page;

    if ( is_feed() ) {
        return $title;
    }

    // Add the site name.
    $title .= get_bloginfo( 'name' );

    // Add the site description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) ) {
        $title = "$title $sep $site_description";
    }

    // Add a page number if necessary.
    if ( $paged >= 2 || $page >= 2 ) {
        $title = "$title $sep " . sprintf( __( 'Page %s', 'twentyfourteen' ), max( $paged, $page ) );
    }

    return $title;

add_filter( 'wp_title', 'orangetechno_wp_title', 10, 2 );
