<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'open_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'open_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'open-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'open_news_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'open-news' ),
		'section'  => 'open_news_single_page_options',
		'settings' => 'open_news_related_posts_title',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'open_news_related_posts_title',
		array(
			'selector'            => '.theme-wrapper h2.related-title',
			'settings'            => 'open_news_related_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}
