<?php
/**
 * Sidebar settings
 */

$wp_customize->add_section(
	'open_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Sidebar Option - Archive Sidebar Position.
$wp_customize->add_setting(
	'open_news_archive_sidebar_position',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'open_news_archive_sidebar_position',
	array(
		'label'   => esc_html__( 'Archive Sidebar Position', 'open-news' ),
		'section' => 'open_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'open-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'open-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'open_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'open_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'open-news' ),
		'section' => 'open_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'open-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'open-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'open_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'open_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'open-news' ),
		'section' => 'open_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'open-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'open-news' ),
		),
	)
);
