<?php

$wp_customize->add_section(
	'open_news_posts_meta_options',
	array(
		'title' => esc_html__( 'Post Meta Options', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Enable post category setting.
$wp_customize->add_setting(
	'open_news_enable_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_enable_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'open-news' ),
			'settings' => 'open_news_enable_category',
			'section'  => 'open_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post author setting.
$wp_customize->add_setting(
	'open_news_enable_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_enable_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'open-news' ),
			'settings' => 'open_news_enable_author',
			'section'  => 'open_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post date setting.
$wp_customize->add_setting(
	'open_news_enable_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_enable_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'open-news' ),
			'settings' => 'open_news_enable_date',
			'section'  => 'open_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post tag setting.
$wp_customize->add_setting(
	'open_news_enable_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_enable_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'open-news' ),
			'settings' => 'open_news_enable_tag',
			'section'  => 'open_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);
