<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'open_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'open_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'open-news' ),
			'settings' => 'open_news_pagination_enable',
			'section'  => 'open_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'open_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'open-news' ),
		'section'         => 'open_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'open-news' ),
			'numeric' => __( 'Numeric', 'open-news' ),
		),
		'active_callback' => 'open_news_pagination_enabled',
	)
);

/*========================Active Callback==============================*/
function open_news_pagination_enabled( $control ) {
	return $control->manager->get_setting( 'open_news_pagination_enable' )->value();
}
