<?php
/**
 * Header Options
 */

// Header Options.
$wp_customize->add_section(
	'open_news_header_section',
	array(
		'title' => esc_html__( 'Header Options', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Enable Topbar Section.
$wp_customize->add_setting(
	'open_news_topbar_section_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_topbar_section_enable',
		array(
			'label'    => esc_html__( 'Enable Topbar Section.', 'open-news' ),
			'settings' => 'open_news_topbar_section_enable',
			'section'  => 'open_news_header_section',
			'type'     => 'checkbox',
		)
	)
);

// Header Advertisement Image.
$wp_customize->add_setting(
	'open_news_header_ads_img',
	array(
		'default'           => '',
		'sanitize_callback' => 'open_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'open_news_header_ads_img',
		array(
			'label'    => esc_html__( 'Advertisement', 'open-news' ),
			'section'  => 'open_news_header_section',
			'settings' => 'open_news_header_ads_img',
		)
	)
);

// Header Advertisement URL.
$wp_customize->add_setting(
	'open_news_header_ads_img_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'open_news_header_ads_img_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'open-news' ),
		'section'  => 'open_news_header_section',
		'settings' => 'open_news_header_ads_img_url',
		'type'     => 'url',
	)
);

// Header Button label setting.
$wp_customize->add_setting(
	'open_news_header_button_label',
	array(
		'default'           => __( 'Sign In', 'open-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'open_news_header_button_label',
	array(
		'label'    => esc_html__( 'Header Button Label', 'open-news' ),
		'section'  => 'open_news_header_section',
		'settings' => 'open_news_header_button_label',
		'type'     => 'text',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'open_news_header_button_label',
		array(
			'selector'            => '.header-button a',
			'settings'            => 'open_news_header_button_label',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Header Button URL setting.
$wp_customize->add_setting(
	'open_news_header_button_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'open_news_header_button_url',
	array(
		'label'    => esc_html__( 'Header Button Link', 'open-news' ),
		'section'  => 'open_news_header_section',
		'settings' => 'open_news_header_button_url',
		'type'     => 'url',
	)
);
