<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'open_news_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'open_news_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'open-news' ),
			'type'     => 'checkbox',
			'settings' => 'open_news_breadcrumb_enable',
			'section'  => 'open_news_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'open_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'open_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'open-news' ),
		'section'         => 'open_news_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'open_news_breadcrumb_enable' )->value() );
		},
	)
);
