<?php
/**
 * Blog / Archive Options
 */

$wp_customize->add_section(
	'open_news_archive_page_options',
	array(
		'title' => esc_html__( 'Blog / Archive Pages Options', 'open-news' ),
		'panel' => 'open_news_theme_options_panel',
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'open_news_excerpt_length',
	array(
		'default'           => 15,
		'sanitize_callback' => 'open_news_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'open_news_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'open-news' ),
		'section'     => 'open_news_archive_page_options',
		'settings'    => 'open_news_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 5,
			'max'  => 200,
			'step' => 1,
		),
	)
);

// Archive Column layout options.
$wp_customize->add_setting(
	'open_news_archive_column_layout',
	array(
		'default'           => 'double-column',
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_archive_column_layout',
	array(
		'label'   => esc_html__( 'Column Layout', 'open-news' ),
		'section' => 'open_news_archive_page_options',
		'type'    => 'select',
		'choices' => array(
			'double-column' => __( 'Column 2', 'open-news' ),
			'triple-column' => __( 'Column 3', 'open-news' ),
		),
	)
);
