<?php
/**
 * Highlights Options
 */

// Highlights Options.
$wp_customize->add_section(
	'open_news_highlights_section',
	array(
		'title' => esc_html__( 'Highlights Section', 'open-news' ),
		'panel' => 'open_news_frontpage_panel',
	)
);


// Highlights News section enable settings.
$wp_customize->add_setting(
	'open_news_highlights_news_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_highlights_news_section_enable',
		array(
			'label'    => esc_html__( 'Enable Highlights News Section', 'open-news' ),
			'type'     => 'checkbox',
			'settings' => 'open_news_highlights_news_section_enable',
			'section'  => 'open_news_highlights_section',
		)
	)
);

// Highlights News title settings.
$wp_customize->add_setting(
	'open_news_highlights_news_title',
	array(
		'default'           => __( 'Highlights News', 'open-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'open_news_highlights_news_title',
	array(
		'label'           => esc_html__( 'Section Title', 'open-news' ),
		'section'         => 'open_news_highlights_section',
		'active_callback' => 'open_news_if_highlights_news_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'open_news_highlights_news_title',
		array(
			'selector'            => '.news-highlights span.highlights-title',
			'settings'            => 'open_news_highlights_news_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Highlights news content type settings.
$wp_customize->add_setting(
	'open_news_highlights_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_highlights_news_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'open-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'open-news' ),
		'section'         => 'open_news_highlights_section',
		'type'            => 'select',
		'active_callback' => 'open_news_if_highlights_news_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'open-news' ),
			'category' => esc_html__( 'Category', 'open-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Highlights news post setting.
	$wp_customize->add_setting(
		'open_news_highlights_news_post_' . $i,
		array(
			'sanitize_callback' => 'open_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'open_news_highlights_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'open-news' ), $i ),
			'section'         => 'open_news_highlights_section',
			'type'            => 'select',
			'choices'         => open_news_get_post_choices(),
			'active_callback' => 'open_news_highlights_news_section_content_type_post_enabled',
		)
	);

}

// Highlights news category setting.
$wp_customize->add_setting(
	'open_news_highlights_news_category',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_highlights_news_category',
	array(
		'label'           => esc_html__( 'Category', 'open-news' ),
		'section'         => 'open_news_highlights_section',
		'type'            => 'select',
		'choices'         => open_news_get_post_cat_choices(),
		'active_callback' => 'open_news_highlights_news_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function open_news_if_highlights_news_enabled( $control ) {
	return $control->manager->get_setting( 'open_news_highlights_news_section_enable' )->value();
}
function open_news_highlights_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_highlights_news_content_type' )->value();
	return open_news_if_highlights_news_enabled( $control ) && ( 'post' === $content_type );
}
function open_news_highlights_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_highlights_news_content_type' )->value();
	return open_news_if_highlights_news_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'open_news_highlights_news_title_text_partial' ) ) :
	// Title.
	function open_news_highlights_news_title_text_partial() {
		return esc_html( get_theme_mod( 'open_news_highlights_news_title' ) );
	}
endif;
