<?php
/**
 * Frontpage Customizer Settings
 *
 * @package Open News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'open_news_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'open-news' ),
		'panel' => 'open_news_frontpage_panel',
	)
);

// Banner section enable settings.
$wp_customize->add_setting(
	'open_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'open_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Open_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'open_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'open-news' ),
			'type'     => 'checkbox',
			'settings' => 'open_news_banner_section_enable',
			'section'  => 'open_news_banner_section',
		)
	)
);

// Banner Featured Sub Heading.
$wp_customize->add_setting(
	'open_news_banner_featured_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Open_News_Section_Sub_Heading_Control(
		$wp_customize,
		'open_news_banner_featured_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Featured Section', 'open-news' ),
			'settings'        => 'open_news_banner_featured_sub_heading',
			'section'         => 'open_news_banner_section',
			'active_callback' => 'open_news_if_banner_enabled',
		)
	)
);

// banner content type settings.
$wp_customize->add_setting(
	'open_news_banner_featured_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_banner_featured_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'open-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'open-news' ),
		'section'         => 'open_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'open_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'open-news' ),
			'category' => esc_html__( 'Category', 'open-news' ),
		),
	)
);

for ( $i = 1; $i <= 6; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'open_news_banner_featured_post_' . $i,
		array(
			'sanitize_callback' => 'open_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'open_news_banner_featured_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'open-news' ), $i ),
			'section'         => 'open_news_banner_section',
			'type'            => 'select',
			'choices'         => open_news_get_post_choices(),
			'active_callback' => 'open_news_banner_featured_content_type_post_enabled',
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'open_news_banner_featured_category',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_banner_featured_category',
	array(
		'label'           => esc_html__( 'Category', 'open-news' ),
		'section'         => 'open_news_banner_section',
		'type'            => 'select',
		'choices'         => open_news_get_post_cat_choices(),
		'active_callback' => 'open_news_banner_featured_content_type_category_enabled',
	)
);

// Banner Slider Sub Heading.
$wp_customize->add_setting(
	'open_news_banner_slider_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Open_News_Section_Sub_Heading_Control(
		$wp_customize,
		'open_news_banner_slider_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Slider Section', 'open-news' ),
			'settings'        => 'open_news_banner_slider_sub_heading',
			'section'         => 'open_news_banner_section',
			'active_callback' => 'open_news_if_banner_enabled',
		)
	)
);

// banner content type settings.
$wp_customize->add_setting(
	'open_news_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'open-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'open-news' ),
		'section'         => 'open_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'open_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'open-news' ),
			'category' => esc_html__( 'Category', 'open-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'open_news_banner_slider_post_' . $i,
		array(
			'sanitize_callback' => 'open_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'open_news_banner_slider_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'open-news' ), $i ),
			'section'         => 'open_news_banner_section',
			'type'            => 'select',
			'choices'         => open_news_get_post_choices(),
			'active_callback' => 'open_news_banner_slider_content_type_post_enabled',
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'open_news_banner_slider_category',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_banner_slider_category',
	array(
		'label'           => esc_html__( 'Category', 'open-news' ),
		'section'         => 'open_news_banner_section',
		'type'            => 'select',
		'choices'         => open_news_get_post_cat_choices(),
		'active_callback' => 'open_news_banner_slider_content_type_category_enabled',
	)
);

// Banner Posts Sub Heading.
$wp_customize->add_setting(
	'open_news_banner_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Open_News_Section_Sub_Heading_Control(
		$wp_customize,
		'open_news_banner_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Posts Section', 'open-news' ),
			'settings'        => 'open_news_banner_posts_sub_heading',
			'section'         => 'open_news_banner_section',
			'active_callback' => 'open_news_if_banner_enabled',
		)
	)
);

// banner content type settings.
$wp_customize->add_setting(
	'open_news_banner_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_banner_posts_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'open-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'open-news' ),
		'section'         => 'open_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'open_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'open-news' ),
			'category' => esc_html__( 'Category', 'open-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'open_news_banner_posts_post_' . $i,
		array(
			'sanitize_callback' => 'open_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'open_news_banner_posts_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'open-news' ), $i ),
			'section'         => 'open_news_banner_section',
			'type'            => 'select',
			'choices'         => open_news_get_post_choices(),
			'active_callback' => 'open_news_banner_posts_content_type_post_enabled',
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'open_news_banner_posts_category',
	array(
		'sanitize_callback' => 'open_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'open_news_banner_posts_category',
	array(
		'label'           => esc_html__( 'Category', 'open-news' ),
		'section'         => 'open_news_banner_section',
		'type'            => 'select',
		'choices'         => open_news_get_post_cat_choices(),
		'active_callback' => 'open_news_banner_posts_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function open_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'open_news_banner_section_enable' )->value();
}
// Banner Slider.
function open_news_banner_slider_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_banner_slider_content_type' )->value();
	return open_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function open_news_banner_slider_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_banner_slider_content_type' )->value();
	return open_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Posts.
function open_news_banner_posts_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_banner_posts_content_type' )->value();
	return open_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function open_news_banner_posts_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_banner_posts_content_type' )->value();
	return open_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Featured.
function open_news_banner_featured_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_banner_featured_content_type' )->value();
	return open_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function open_news_banner_featured_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'open_news_banner_featured_content_type' )->value();
	return open_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
