<?php 
/**
 * Perform all main WooCommerce configurations for this theme
 *
 * @package  Open Mart WordPress theme
 */
// If plugin - 'WooCommerce' not exist then return.
if ( ! class_exists( 'WooCommerce' ) ){
     return;
}

if ( ! function_exists( 'is_plugin_active' ) ){
         require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

/***********************************************/
//Sort section Woocommerce category filter show
/***********************************************/
function open_mart_add_to_cart_url($product){
  $defaults = array(
    'quantity'   => 1,
    'class'      => implode(
        ' ',
        array_filter(
            array(
                'button',
                'product_type_' . $product->get_type(),
                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                $product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
            )
        )
    ),
    'attributes' => array(
        'data-product_id'  => $product->get_id(),
        'data-product_sku' => $product->get_sku(),
        'aria-label'       => $product->add_to_cart_description(),
        'rel'              => 'nofollow',
    ),
);
  $args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $defaults ), $product );
  $cart_url = sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="button th-button %s" %s><span>%s</span></a>',
        esc_url( $product->add_to_cart_url() ),
        esc_attr( $product->get_id() ),
        esc_attr( $product->get_sku() ),
        esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
        esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
    isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
       esc_html( $product->add_to_cart_text() )
     );
 return $cart_url;
}
/**********************************/
//Shop Product Markup
/**********************************/
if ( ! function_exists( 'open_mart_product_meta_start' ) ){
  /**
   * Thumbnail wrap start.
   */
  function open_mart_product_meta_start(){
    echo '<div class="thunk-product-wrap"><div class="thunk-product">';
  }
}
if ( ! function_exists( 'open_mart_product_meta_end' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_product_meta_end(){

    echo '</div></div>';
  }
}
/**********************************/
//Shop Product Image Markup
/**********************************/
if ( ! function_exists( 'open_mart_product_image_start' ) ){
  /**
   * Thumbnail wrap start.
   */
  function open_mart_product_image_start(){
    echo '<div class="thunk-product-image">';
  }
}
if ( ! function_exists( 'open_mart_product_image_end' ) ){

  /**
   * Thumbnail wrap start.
   */
    function open_mart_product_image_end(){
    echo woocommerce_template_loop_rating();
    do_action('quickview');
    echo '</div>';
  }
}

if ( ! function_exists( 'open_mart_product_content_start' ) ){
  /**
   * Thumbnail wrap start.
   */
  function open_mart_product_content_start(){
    echo '<div class="thunk-product-content">';
  }
}
if ( ! function_exists( 'open_mart_product_content_end' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_product_content_end(){

    echo '</div>';
  }
}
 /**
   * Thunk-product-hover start.
   */
 if ( ! function_exists( 'open_mart_product_hover_start' ) ){
  function open_mart_product_hover_start(){
    echo'<div class="thunk-product-hover">';
  }
}
if ( ! function_exists( 'open_mart_product_hover_end' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_product_hover_end(){
    
    echo '</div>';
  }
}

if ( ! function_exists( 'open_mart_shop_content_start' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_shop_content_start(){
    $viewshow = get_theme_mod('open_mart_prd_view','grid-view');
    if($viewshow == 'grid-view'){
    echo '<div id="shop-product-wrap" class="thunk-grid-view">';
    }else{
    echo '<div id="shop-product-wrap" class="thunk-list-view">';
    }
  }
}

if ( ! function_exists( 'open_mart_shop_content_end' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_shop_content_end(){
    
    echo '</div>';
  }
}
/**
* Shop customization.
*
* @return void
*/
add_action( 'woocommerce_before_shop_loop_item', 'open_mart_product_meta_start', 10);
add_action( 'woocommerce_after_shop_loop_item', 'open_mart_product_meta_end', 12 );
add_action( 'woocommerce_before_shop_loop_item_title', 'open_mart_product_content_start',20);
add_action( 'woocommerce_after_shop_loop_item_title', 'open_mart_product_content_end', 20 );
add_action( 'woocommerce_after_shop_loop_item_title', 'open_mart_product_hover_start',50);
add_action( 'woocommerce_after_shop_loop_item', 'open_mart_product_hover_end',20);
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open',20);
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open',9);
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close',10);
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price',0);
add_action( 'woocommerce_before_shop_loop_item_title', 'open_mart_product_image_start', 0);
add_action( 'woocommerce_before_shop_loop_item_title', 'open_mart_product_image_end',10);
add_action( 'woocommerce_after_single_product_summary', 'woocommerce_show_product_sale_flash',4);
add_action( 'woocommerce_after_shop_loop_item', 'open_mart_whish_list_both',11);
add_action( 'woocommerce_after_shop_loop_item', 'open_mart_add_to_compare_fltr_single',11);

add_action( 'woocommerce_before_shop_loop', 'open_mart_shop_content_start',1);
add_action( 'woocommerce_after_shop_loop', 'open_mart_shop_content_end',1);

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open',10);
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action('woocommerce_init','th_compare_add_action_shop_list');
//To disable th compare Pro button 
remove_action('woocommerce_init', 'tpcp_add_action_shop_list');

// To disable Wishlist button for loop button at shop page
remove_action( 'wp', 'thwl_hook_wishlist_loop_button_position');

// To disable Wishlist button for loop button at single page
// remove_action( 'wp', 'thwl_hook_wishlist_single_button_position');

//To integrate with a theme, please use bellow filters to hide the default buttons. hide default wishlist button on product archive page
add_filter( 'woosw_button_position_archive', function() {
    return '0';
} );

//hide default compare button on product archive page
add_filter( 'filter_wooscp_button_archive', function() {
    return '0';
} );

/***************/
// single page
/***************/
if ( ! function_exists( 'open_mart_single_summary_start' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_single_summary_start(){
    
    echo '<div class="thunk-single-product-summary-wrap">';
  }
}
if( ! function_exists( 'open_mart_single_summary_end' ) ){

  /**
   * Thumbnail wrap start.
   */
  function open_mart_single_summary_end(){
    
    echo '</div>';
  }
}
add_action( 'woocommerce_before_single_product_summary', 'open_mart_single_summary_start',0);
add_action( 'woocommerce_after_single_product_summary', 'open_mart_single_summary_end',0);


/*********************************/
/** whishlist and compare both **/
/*******************************/

if ( ! function_exists('open_mart_whish_list_both')){
 function open_mart_whish_list_both($pid){
   global $product;
   $pid = $product->get_id();
      
        open_mart_whish_list($pid);
}
}

if ( ! function_exists('open_mart_add_to_compare_fltr_both')){
function open_mart_add_to_compare_fltr_both($pid){
  if( class_exists( 'th_product_compare' ) || class_exists('Tpcp_product_compare') ){
             open_mart_add_to_compare_fltr($pid);      
                }
}
}





/************************/
// Th Product Compare
/************************/

function open_mart_add_to_compare_fltr_single($pid){
        if(class_exists('th_product_compare') || class_exists('Tpcp_product_compare')){
    global $product;
    $pid = $product->get_id();
    echo '<div class="thunk-compare"><span class="compare-list"><div class="woocommerce product compare-button">
          <a class="th-product-compare-btn compare" data-th-product-id="'.esc_attr($pid).'"></a>
          </div></span></div>';

           }
           
}


function open_mart_add_to_compare_fltr($pid){
      if(class_exists('th_product_compare') || class_exists('Tpcp_product_compare')){
    global $product;
    $pid = $product->get_id();
    echo '<div class="thunk-compare"><span class="compare-list"><div class="woocommerce product compare-button">
          <a class="th-product-compare-btn compare" data-th-product-id="'.esc_attr($pid).'"></a>
          </div></span></div>';

           }elseif( ( class_exists( 'WPCleverWoosc' ))){
           echo '<div class="thunk-compare">'.do_shortcode('[woosc id='.$pid.']').'</div>';
         }

        
}
/**********************/
/** wishlist **/
/**********************/

function open_mart_whish_list_single($pid){
       if( shortcode_exists( 'yith_wcwl_add_to_wishlist' )){
        echo '<div class="thunk-wishlist"><span class="thunk-wishlist-inner">'.do_shortcode('[yith_wcwl_add_to_wishlist icon="th-icon th-icon-favorite_outline" label="" already_in_wishslist_text="Already" browse_wishlist_text=""]' ).'</span></div>';
       }
}


function open_mart_whish_list($pid){
        if ( shortcode_exists( 'thwl_add_to_wishlist' ) ) { ?>
              <div class="thunk-wishlist">
                <span class="thunk-wishlist-inner">
                  <?= do_shortcode('[thwl_add_to_wishlist 
                    product_id="' . esc_attr($pid) . '" 
                    add_icon="th-icon th-icon-heart1" 
                    add_text="" 
                    add_browse_icon="th-icon th-icon-favorite"
                    browse_text=""
                    theme_style="yes"
                    icon_style="icon_only_no_style"
                    custom_class="th-wishlist-integrated"
                  ]'); ?>
                </span>
              </div>
        <?php } elseif ( shortcode_exists( 'yith_wcwl_add_to_wishlist' ) ) { ?>
          <div class="thunk-wishlist">
            <span class="thunk-wishlist-inner">
              <?= do_shortcode('[yith_wcwl_add_to_wishlist icon="th-icon th-icon-favorite_outline" label="" already_in_wishslist_text="Already" browse_wishlist_text=""]'); ?>
            </span>
          </div>
        <?php } 

 } 

/**********************/
/** wishlist url**/
/**********************/
function open_mart_whishlist_url(){
   $wishlist_page_id = '';
  if ( shortcode_exists( 'thwl_add_to_wishlist' ) ) {
    $wishlist_page_id =  get_option( 'thwl_page_id' );
  }
  elseif( class_exists( 'YITH_WCWL' ) ){
    $wishlist_page_id =  get_option( 'yith_wcwl_wishlist_page_id' );
  }
$wishlist_permalink = get_the_permalink( $wishlist_page_id );
return $wishlist_permalink ;
}
// shop open
/** My Account Menu **/
function open_mart_account(){
 if ( is_user_logged_in() ) {
  $return = '<a class="account" href="'.get_permalink( get_option('woocommerce_myaccount_page_id') ).'" aria-label="account" title="Account"><i class="th-icon th-icon-user" aria-hidden="true"></i></a>';
  } 
 else {
  $return = '<span><a href="'.get_permalink( get_option('woocommerce_myaccount_page_id') ).'" aria-label="account" title="Account"><i class="th-icon th-icon-user" aria-hidden="true"></i></a></span>';
}
 echo $return;
 }

// Plus Minus Quantity Buttons @ WooCommerce Single Product Page
add_action( 'woocommerce_before_add_to_cart_quantity', 'open_mart_display_quantity_minus',10,2 );
function open_mart_display_quantity_minus(){
    echo '<div class="open-mart-quantity"><button type="button" class="minus" >-</button>';
}
add_action( 'woocommerce_after_add_to_cart_quantity', 'open_mart_display_quantity_plus',10,2 );
function open_mart_display_quantity_plus(){
    echo '<button type="button" class="plus" >+</button></div>';
}

//Woocommerce: How to remove page-title at the home/shop page archive & category pages
add_filter('woocommerce_show_page_title', '__return_null');

function open_mart_not_a_shop_page() {
    return boolval(!is_shop());
}
//************************************************************************************************//
// *****************************HOME PAGE WOO FUNCTION****************************************//
//************************************************************************************************//
//***********************/
// product category list
//************************/
function open_mart_product_list_categories( $args = '' ){
    $defaults = array(
        'child_of'            => 0,
        'current_category'    => 0,
        'depth'               => 4,
        'echo'                => 0,
        'exclude'             => '',
        'exclude_tree'        => '',
        'feed'                => '',
        'feed_image'          => '',
        'feed_type'           => '',
        'hide_empty'          => 1,
        'hide_title_if_empty' => false,
        'hierarchical'        => true,
        'order'               => 'ASC',
        'orderby'             => 'menu_order',
        'separator'           => '<br />',
        'show_count'          => 0,
        'show_option_all'     => '',
        'show_option_none'    => __( 'No categories','open-mart' ),
        'style'               => 'list',
        'taxonomy'            => 'product_cat',
        'title_li'            => '',
        'use_desc_for_title'  => 0,
    );
 $html = wp_list_categories($defaults);
        echo '<ul class="product-cat-list thunk-product-cat-list" data-menu-style="vertical">'.$html.'</ul>';
  }
  // This is for vertical style in open mart
function open_mart_product_list_categories_mobile( $args = '' ){
    $defaults = array(
        'child_of'            => 0,
        'current_category'    => 0,
        'depth'               => 4,
        'echo'                => 0,
        'exclude'             => '',
        'exclude_tree'        => '',
        'feed'                => '',
        'feed_image'          => '',
        'feed_type'           => '',
        'hide_empty'          => 1,
        'hide_title_if_empty' => false,
        'hierarchical'        => true,
        'order'               => 'ASC',
        'orderby'             => 'menu_order',
        'separator'           => '<br />',
        'show_count'          => 0,
        'show_option_all'     => '',
        'show_option_none'    => __( 'No categories','open-mart' ),
        'style'               => 'list',
        'taxonomy'            => 'product_cat',
        'title_li'            => '',
        'use_desc_for_title'  => 0,
    );
 $html = wp_list_categories($defaults);
        echo '<ul class="thunk-product-cat-list mobile" data-menu-style="accordion">'.$html.'</ul>';
  }