<?php

/**
 * Title: Why Choose Us Section
 * Slug: online-learning/why-choose-us-section
 * Description: A section with an image, headline, and short description to showcase your key strengths.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */
?>

<!-- wp:group {"className":"animate-box-group","style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group animate-box-group"><!-- wp:heading {"textAlign":"center"} -->
	<h2 class="wp-block-heading has-text-align-center">Why choose us?</h2>
	<!-- /wp:heading -->

	<!-- wp:columns -->
	<div class="wp-block-columns">
		<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20"},"border":{"radius":"8px","width":"1px"}},"borderColor":"border-color"} -->
		<div class="wp-block-column has-border-color has-border-color-border-color" style="border-width:1px;border-radius:8px;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
			<!-- wp:image {"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
			<figure class="wp-block-image size-large has-custom-border">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/online-learning-export-instructors.jpg' ); ?>" alt="Export Instructors" style="border-radius:8px" />
			</figure>
			<!-- /wp:image -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"12px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group"><!-- wp:heading {"level":5} -->
				<h5 class="wp-block-heading">Expert Instructors</h5>
				<!-- /wp:heading -->

				<!-- wp:paragraph -->
				<p>Learn from seasoned experts. Real world knowledge. Passionate, professional teaching.</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20"},"border":{"radius":"8px","width":"1px"}},"borderColor":"border-color"} -->
		<div class="wp-block-column has-border-color has-border-color-border-color" style="border-width:1px;border-radius:8px;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
			<!-- wp:image {"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
			<figure class="wp-block-image size-large has-custom-border">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/online-learning-flexible-learning.jpg' ); ?>" alt="Flexible Learning" style="border-radius:8px" />
			</figure>
			<!-- /wp:image -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"12px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group"><!-- wp:heading {"level":5} -->
				<h5 class="wp-block-heading">Flexible Learning</h5>
				<!-- /wp:heading -->

				<!-- wp:paragraph -->
				<p>Study anytime, anywhere. Fits your busy lifestyle. Great for work or school.</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20"},"border":{"radius":"8px","width":"1px"}},"borderColor":"border-color"} -->
		<div class="wp-block-column has-border-color has-border-color-border-color" style="border-width:1px;border-radius:8px;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
			<!-- wp:image {"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
			<figure class="wp-block-image size-large has-custom-border">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/online-learning-practical-curriculum.jpg' ); ?>" alt="Practical Curriculum" style="border-radius:8px" />
			</figure>
			<!-- /wp:image -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"12px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group"><!-- wp:heading {"level":5} -->
				<h5 class="wp-block-heading">Practical Curriculum</h5>
				<!-- /wp:heading -->

				<!-- wp:paragraph -->
				<p>Hands-on projects and quizzes. Real skills for real jobs. Learn by doing.</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20"},"border":{"radius":"8px","width":"1px"}},"borderColor":"border-color"} -->
		<div class="wp-block-column has-border-color has-border-color-border-color" style="border-width:1px;border-radius:8px;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
			<!-- wp:image {"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
			<figure class="wp-block-image size-large has-custom-border">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/online-learning-career-focused-outcomes.jpg' ); ?>" alt="Career Focused Outcomes" style="border-radius:8px" />
			</figure>
			<!-- /wp:image -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"12px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group"><!-- wp:heading {"level":5} -->
				<h5 class="wp-block-heading">Career-Focused Outcomes</h5>
				<!-- /wp:heading -->

				<!-- wp:paragraph -->
				<p>Gain job-ready skills fast. Career support included. Reach your goals quicker.</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
