<?php
/**
 * Title: List of posts 3 columns
 * Slug: online-learning/template-query-loop-3-column
 * Categories: query
 * Block Types: core/query
 * Description: A list of posts, with featured image and post date.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */

?>
<!-- wp:query {"className":"column-3","query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":true,"taxQuery":null,"parents":[]},"align":"full","layout":{"type":"default"}} -->
<div class="wp-block-query column-3 alignfull">
	<!-- wp:post-template {"align":"full","layout":{"type":"default"}} -->
		<!-- wp:group -->
		<div class="wp-block-group">
			<!-- wp:post-featured-image {"isLink":true,"aspectRatio":"3/2"} /-->
			<!-- wp:post-terms {"term":"category","className":"post-category"} /-->
			<!-- wp:post-title {"isLink":true,"fontSize":"large"} /-->
			<!-- wp:group {"className":"wp-block-group-author-date-post","style":{"spacing":{"margin":{"top":"12px"},"blockGap":"0"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
			<div class="wp-block-group wp-block-group-author-date-post" style="margin-top:12px">
				<!-- wp:paragraph {"fontSize":"small"} -->
				<p class="has-small-font-size label-author"><?php echo esc_html__( 'by', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:post-author-name {"fontSize":"small"} /-->
				<!-- wp:post-date /-->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:group -->
	<!-- /wp:post-template -->
	<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}},"layout":{"type":"constrained"}} -->
	<div class="wp-block-group">
		<!-- wp:query-no-results -->
		<!-- wp:paragraph -->
		<p><?php echo esc_html_x( 'Sorry, but nothing was found. Please try a search with different keywords.', 'Message explaining that there are no results returned from a search.', 'online-learning' ); ?></p>
		<!-- /wp:paragraph -->
		<!-- /wp:query-no-results -->
	</div>
	<!-- /wp:group -->
	<!-- wp:group {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignwide" style="margin-top:var(--wp--preset--spacing--30)">
		<!-- wp:query-pagination {"paginationArrow":"arrow","showLabel":false,"align":"wide","layout":{"type":"flex","justifyContent":"center"}} -->
			<!-- wp:query-pagination-previous /-->
			<!-- wp:query-pagination-numbers /-->
			<!-- wp:query-pagination-next /-->
		<!-- /wp:query-pagination -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:query -->
