<?php

/**
 * Title: Sidebar
 * Slug: online-learning/sidebar-primary
 * Block Types: core/template-part/sidebar
 * Description: Primary sidebar area for widgets or additional content.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */
?>
<!-- wp:group {"className":"sidebar-box","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"},"blockGap":"20px","padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"}},"border":{"radius":{"topLeft":"8px","topRight":"8px","bottomLeft":"8px","bottomRight":"8px"},"width":"1px"}},"backgroundColor":"background","borderColor":"border-color"} -->
<div class="wp-block-group sidebar-box has-border-color has-border-color-border-color has-background-background-color has-background" style="border-width:1px;border-top-left-radius:8px;border-top-right-radius:8px;border-bottom-left-radius:8px;border-bottom-right-radius:8px;margin-bottom:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
	<!-- wp:heading {"level":3} -->
	<h3 class="wp-block-heading" ><?php echo esc_html__( 'Search', 'online-learning' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:search {"label":"Search","showLabel":false,"width":100,"widthUnit":"%","buttonText":"Search","buttonUseIcon":true,"backgroundColor":"accent","fontSize":"tiny"} /-->
</div>
<!-- /wp:group -->

<!-- wp:group {"className":"sidebar-box","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"},"blockGap":"20px","padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"}},"border":{"radius":{"topLeft":"8px","topRight":"8px","bottomLeft":"8px","bottomRight":"8px"},"width":"1px"}},"backgroundColor":"background","borderColor":"border-color"} -->
<div class="wp-block-group sidebar-box has-border-color has-border-color-border-color has-background-background-color has-background" style="border-width:1px;border-top-left-radius:8px;border-top-right-radius:8px;border-bottom-left-radius:8px;border-bottom-right-radius:8px;margin-bottom:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
	<!-- wp:heading {"level":3} -->
	<h3 class="wp-block-heading" ><?php echo esc_html__( 'Latest Posts', 'online-learning' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:query {"className":"latest-posts-sidebar","query":{"perPage":"3","pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
	<div class="wp-block-query latest-posts-sidebar"><!-- wp:post-template -->
		<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} -->
		<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:post-featured-image {"isLink":true,"width":""} /--></div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","width":"75%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:75%"><!-- wp:post-title {"level":5,"isLink":true} /-->

				<!-- wp:post-excerpt {"excerptLength":10,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} /-->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
		<!-- /wp:post-template -->
	</div>
	<!-- /wp:query -->
</div>
<!-- /wp:group -->

<!-- wp:group {"className":"sidebar-box","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"},"blockGap":"20px","padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"}},"border":{"radius":{"topLeft":"8px","topRight":"8px","bottomLeft":"8px","bottomRight":"8px"},"width":"1px"}},"backgroundColor":"background","borderColor":"border-color"} -->
<div class="wp-block-group sidebar-box has-border-color has-border-color-border-color has-background-background-color has-background" style="border-width:1px;border-top-left-radius:8px;border-top-right-radius:8px;border-bottom-left-radius:8px;border-bottom-right-radius:8px;margin-bottom:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
	<!-- wp:heading {"level":3} -->
	<h3 class="wp-block-heading" ><?php echo esc_html__( 'Archive', 'online-learning' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:archives {"style":{"typography":{"lineHeight":"1.8"}},"fontSize":"upper-heading"} /-->
</div>
<!-- /wp:group -->

<!-- wp:group {"className":"sidebar-box","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"},"blockGap":"20px","padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"}},"border":{"radius":{"topLeft":"8px","topRight":"8px","bottomLeft":"8px","bottomRight":"8px"},"width":"1px"}},"backgroundColor":"background","borderColor":"border-color"} -->
<div class="wp-block-group sidebar-box has-border-color has-border-color-border-color has-background-background-color has-background" style="border-width:1px;border-top-left-radius:8px;border-top-right-radius:8px;border-bottom-left-radius:8px;border-bottom-right-radius:8px;margin-bottom:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
	<!-- wp:heading {"level":3} -->    
	<h3 class="wp-block-heading" ><?php echo esc_html__( 'Categories', 'online-learning' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:categories {"style":{"typography":{"lineHeight":"1.8"}},"fontSize":"upper-heading"} /-->
</div>
<!-- /wp:group -->

<!-- wp:group {"className":"sidebar-box","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"},"blockGap":"20px","padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"}},"border":{"radius":{"topLeft":"8px","topRight":"8px","bottomLeft":"8px","bottomRight":"8px"},"width":"1px"}},"backgroundColor":"background","borderColor":"border-color"} -->
<div class="wp-block-group sidebar-box has-border-color has-border-color-border-color has-background-background-color has-background" style="border-width:1px;border-top-left-radius:8px;border-top-right-radius:8px;border-bottom-left-radius:8px;border-bottom-right-radius:8px;margin-bottom:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
	<!-- wp:heading {"level":3} -->
	<h3 class="wp-block-heading" ><?php echo esc_html__( 'Socials', 'online-learning' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:social-links {"className":"is-style-default","style":{"spacing":{"blockGap":{"top":"20px","left":"18px"}}},"layout":{"type":"flex"}} -->
	<ul class="wp-block-social-links is-style-default"><!-- wp:social-link {"url":"3","service":"twitter"} /-->

		<!-- wp:social-link {"url":"#","service":"youtube"} /-->

		<!-- wp:social-link {"url":"#","service":"facebook"} /-->

		<!-- wp:social-link {"url":"#","service":"linkedin"} /-->
	</ul>
	<!-- /wp:social-links -->
</div>
<!-- /wp:group -->
