<?php
/**
 * Title: Pricing Plan
 * Slug: online-learning/pricing-plan
 * Description: A pricing table with 3 pricing plans for learners.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */
?>

<!-- wp:group {"className":"animate-box-group","style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group animate-box-group">
	<!-- wp:group {"layout":{"type":"constrained"}} -->
	<div class="wp-block-group">
		<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"},"color":{"text":"#207dfe"},"elements":{"link":{"color":{"text":"#207dfe"}}}}} -->
		<p class="has-text-align-center has-text-color has-link-color" style="color:#207dfe;font-style:normal;font-weight:500;text-transform:uppercase"><?php echo esc_html__( 'Pricing plan', 'online-learning' ); ?></p>
		<!-- /wp:paragraph -->

		<!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"top":"12px"}}}} -->
		<h2 class="wp-block-heading has-text-align-center" style="margin-top:12px"><?php echo esc_html__( 'Flexible Plans for Every Learner', 'online-learning' ); ?></h2>
		<!-- /wp:heading -->
	</div>
	<!-- /wp:group -->

	<!-- wp:columns {"className":"wp-block-pricing-plan"} -->
	<div class="wp-block-columns wp-block-pricing-plan">
		<?php
		$plans = array(
			array(
				'title'       => __( 'Basic Plan', 'online-learning' ),
				'price'       => '$19.0',
				'suffix'      => '/month',
				'description' => __( 'Perfect for beginners getting started', 'online-learning' ),
				'features'    => array(
					__( 'Access to 10+ beginner courses', 'online-learning' ),
					__( 'Learn anytime, anywhere', 'online-learning' ),
					__( 'Downloadable PDF materials', 'online-learning' ),
					__( 'Email support', 'online-learning' ),
				),
				'button'      => __( 'Sign up now', 'online-learning' ),
			),
			array(
				'title'       => __( 'Premium Plan', 'online-learning' ),
				'price'       => '$59.0',
				'suffix'      => '/month',
				'description' => __( 'Ideal for serious learners upgrading their skills', 'online-learning' ),
				'features'    => array(
					__( 'Full access to all courses', 'online-learning' ),
					__( 'Advanced & in-depth content', 'online-learning' ),
					__( 'Certificate of completion', 'online-learning' ),
					__( 'Join the learning community', 'online-learning' ),
					__( 'Live chat support', 'online-learning' ),
				),
				'button'      => __( 'Start learning today', 'online-learning' ),
			),
			array(
				'title'       => __( 'Lifetime Plan', 'online-learning' ),
				'price'       => '$159.0',
				'suffix'      => '/one-time payment',
				'description' => __( 'Perfect for beginners getting started', 'online-learning' ),
				'features'    => array(
					__( 'Lifetime access to all current & future courses', 'online-learning' ),
					__( 'Free updates on new courses', 'online-learning' ),
					__( 'Special offers for workshops & events', 'online-learning' ),
					__( 'Priority 1:1 support', 'online-learning' ),
				),
				'button'      => __( 'Buy once – learn forever', 'online-learning' ),
			),
		);

		foreach ( $plans as $plan ) :
			?>
			<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)">
				<!-- wp:group {"style":{"spacing":{"blockGap":"16px"}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group">
					<!-- wp:heading {"level":5} -->
					<h5 class="wp-block-heading"><?php echo esc_html( $plan['title'] ); ?></h5>
					<!-- /wp:heading -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"4px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"style":{"typography":{"fontSize":"36px","fontStyle":"normal","fontWeight":"700","lineHeight":"1.2"},"color":{"text":"#ff3838"},"elements":{"link":{"color":{"text":"#ff3838"}}}}} -->
						<p class="has-text-color has-link-color" style="color:#ff3838;font-size:36px;font-style:normal;font-weight:700;line-height:1.2"><?php echo esc_html( $plan['price'] ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:paragraph -->
						<p><?php echo esc_html( $plan['suffix'] ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:paragraph -->
					<p><?php echo esc_html( $plan['description'] ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10","margin":{"top":"var:preset|spacing|20"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--20)">
					<?php foreach ( $plan['features'] as $feature ) : ?>
						<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left","verticalAlignment":"center"}} -->
						<div class="wp-block-group">
							<!-- wp:paragraph -->
							<p><span>✅ </span><?php echo esc_html( $feature ); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:group -->
					<?php endforeach; ?>
				</div>
				<!-- /wp:group -->

				<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"stretch","orientation":"vertical"}} -->
				<div class="wp-block-buttons">
					<!-- wp:button {"textAlign":"center","className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline">
						<a href="#" class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html( $plan['button'] ); ?></a>
					</div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:column -->
		<?php endforeach; ?>
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
