<?php
/**
 * Title: Hero Section
 * Slug: online-learning/hero-section
 * Description: A hero section with a headline, description, image, and call-to-action buttons.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */
?>
<!-- wp:group {"style":{"color":{"background":"#e5f7ff"},"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#e5f7ff;padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20)">
	<!-- wp:columns -->
	<div class="wp-block-columns">
		<!-- wp:column {"verticalAlignment":"center","className":"animate-box-group","style":{"spacing":{"blockGap":"0","padding":{"top":"0","bottom":"0"}}}} -->
		<div class="wp-block-column is-vertically-aligned-center animate-box-group" style="padding-top:0;padding-bottom:0">
			<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|heading"}}},"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"textColor":"heading","fontSize":"large"} -->
			<p class="has-heading-color has-text-color has-link-color has-large-font-size" style="margin-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:600;text-transform:uppercase">
				<?php echo esc_html__( 'Learn UI/UX Design with', 'online-learning' ); ?>
			</p>
			<!-- /wp:paragraph -->

			<!-- wp:heading {"level":1,"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|10"}}}} -->
			<h1 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--10)">
				<?php echo esc_html__( 'Your Next Big Step Starts Here', 'online-learning' ); ?>
			</h1>
			<!-- /wp:heading -->

			<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|heading"}}},"spacing":{"margin":{"bottom":"var:preset|spacing|30"}}},"textColor":"heading","fontSize":"x-large"} -->
			<p class="has-heading-color has-text-color has-link-color has-x-large-font-size" style="margin-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:700">
				<?php echo esc_html__( 'Join thousands of students leveling up their skills online.', 'online-learning' ); ?>
			</p>
			<!-- /wp:paragraph -->

			<!-- wp:buttons {"style":{"spacing":{"blockGap":{"left":"12px"}}}} -->
			<div class="wp-block-buttons">
				<!-- wp:button -->
				<div class="wp-block-button">
					<a class="wp-block-button__link wp-element-button" href="/courses/">
						<?php echo esc_html__( 'Explore courses', 'online-learning' ); ?>
					</a>
				</div>
				<!-- /wp:button -->

				<!-- wp:button {"className":"wp-block-button__outline is-style-outline"} -->
				<div class="wp-block-button wp-block-button__outline is-style-outline">
					<a class="wp-block-button__link wp-element-button" href="/about/">
						<?php echo esc_html__( 'About us', 'online-learning' ); ?>
					</a>
				</div>
				<!-- /wp:button -->
			</div>
			<!-- /wp:buttons -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"className":"wp-block-column-relative"} -->
		<div class="wp-block-column wp-block-column-relative">
			<!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
			<figure class="wp-block-image size-full">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/online-learning-hero-section.png' ); ?>" alt="<?php echo esc_attr__( 'Teacher Image', 'online-learning' ); ?>" />
			</figure>
			<!-- /wp:image -->

			<!-- wp:group {"className":"wp-block-hero-section-box left-bottom animate-updown","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"radius":"10px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group wp-block-hero-section-box left-bottom animate-updown" style="border-radius:10px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
				<div class="wp-block-group">
					<!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/student-in-class.png' ); ?>" alt="<?php echo esc_attr__( 'Students Image', 'online-learning' ); ?>" />
					</figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"4px"}},"layout":{"type":"constrained"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":4,"textColor":"white"} -->
						<h4 class="wp-block-heading has-white-color has-text-color">
							<?php echo esc_html__( '2k Students', 'online-learning' ); ?>
						</h4>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"textColor":"white"} -->
						<p class="has-white-color has-text-color">
							<?php echo esc_html__( 'Join our online Class', 'online-learning' ); ?>
						</p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->

			<!-- wp:group {"className":"wp-block-hero-section-box top-right animate-updown block-mobile-none","style":{"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"4px"},"border":{"radius":"10px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group wp-block-hero-section-box top-right animate-updown block-mobile-none" style="border-radius:10px;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)">
				<!-- wp:heading {"level":4,"textColor":"white"} -->
				<h4 class="wp-block-heading has-white-color has-text-color">
					<?php echo esc_html__( '+30 Years', 'online-learning' ); ?>
				</h4>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"textColor":"white"} -->
				<p class="has-white-color has-text-color">
					<?php echo esc_html__( 'Teaching experience', 'online-learning' ); ?>
				</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
