<?php

/**
 * Title: Header
 * Slug: online-learning/header
 * Block Types: core/template-part/header
 * Description: Site header with site title and navigation.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */
?>

<!-- wp:group {"className":"header-main","layout":{"type":"constrained"}} -->
<div class="wp-block-group header-main"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
	<div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"40%"} -->
		<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%">
			<!-- wp:image {"sizeSlug":"full"} -->
			<figure class="wp-block-image size-full">
				<a href="#">
					<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/logo.png' ); ?>" alt="Logo" />
				</a>
			</figure>
			<!-- /wp:image -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"verticalAlignment":"center","width":"60%"} -->
		<div class="wp-block-column header-right is-vertically-aligned-center" style="flex-basis:60%"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"right"}} -->
			<div class="wp-block-group">
				<!-- wp:navigation {"textColor":"heading","icon":"menu","layout":{"type":"flex","justifyContent":"right"},"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
					<!-- wp:navigation-link {"label":"Home","type":"page","url":"#"} /-->
					<!-- wp:navigation-link {"label":"Courses","type":"page","url":"#"} /-->
					<!-- wp:navigation-link {"label":"About","type":"page","url":"#"} /-->
					<!-- wp:navigation-link {"label":"Blog","type":"page","url":"#"} /-->
					<!-- wp:navigation-link {"label":"Contact","type":"page","url":"#"} /-->
				<!-- /wp:navigation -->
				<!-- wp:loginout /-->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
