<?php
/**
 * Title: Footer
 * Slug: online-learning/footer
 * Block Types: core/template-part/footer
 * Description: Footer columns with logo, title, tagline and links.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */

?>

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"top":{"width":"1px","color":"var:preset|color|border-color"},"right":{"width":"0px","style":"none"},"bottom":{"width":"0px","style":"none"},"left":{"width":"0px","style":"none"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group footer" style="border-top-color:var(--wp--preset--color--border-color);border-top-width:1px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)">
	<!-- wp:columns {"style":{"spacing":{"padding":{"top":"0","bottom":"0"}}}} -->
	<div class="wp-block-columns" style="padding-top:0;padding-bottom:0">
		<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"top":"0","bottom":"0"}}}} -->
		<div class="wp-block-column" style="padding-top:0;padding-bottom:0">
			<!-- wp:heading {"level":5} -->
			<h5 class="wp-block-heading"><?php esc_html_e( 'About us', 'online-learning' ); ?></h5>
			<!-- /wp:heading -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"16px"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group">
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'We are providing high-quality courses for about ten years.', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:social-links {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|10"}}}} -->
				<ul class="wp-block-social-links">
					<!-- wp:social-link {"url":"#","service":"facebook","rel":"#"} /-->
					<!-- wp:social-link {"url":"#","service":"x"} /-->
					<!-- wp:social-link {"url":"#","service":"instagram"} /-->
					<!-- wp:social-link {"url":"#","service":"youtube"} /-->
					<!-- wp:social-link {"url":"#","service":"tiktok"} /-->
				</ul>
				<!-- /wp:social-links -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"top":"0","bottom":"0"}}}} -->
		<div class="wp-block-column" style="padding-top:0;padding-bottom:0">
			<!-- wp:heading {"level":5} -->
			<h5 class="wp-block-heading"><?php esc_html_e( 'Quick links', 'online-learning' ); ?></h5>
			<!-- /wp:heading -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group">
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Partner', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Advertise', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Become an Affiliate', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Affiliate Terms & Policies', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|20","padding":{"top":"0","bottom":"0"}}}} -->
		<div class="wp-block-column" style="padding-top:0;padding-bottom:0">
			<!-- wp:heading {"level":5} -->
			<h5 class="wp-block-heading"><?php esc_html_e( 'Need help?', 'online-learning' ); ?></h5>
			<!-- /wp:heading -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group">
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Call us:', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading"}}}},"textColor":"heading"} -->
				<p class="has-heading-color has-text-color has-link-color"><strong><?php esc_html_e( '+1 234 567 890', 'online-learning' ); ?></strong></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Send email:', 'online-learning' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading"}}}},"textColor":"heading"} -->
				<p class="has-heading-color has-text-color has-link-color"><strong><?php esc_html_e( 'info@example.com', 'online-learning' ); ?></strong></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
