<?php
/**
 * Title: Banner Section
 * Slug: online-learning/banner-section
 * Description: A banner section with a headline, description, background image, and call-to-action button.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */

// Prepare variables
$title       = esc_html__( 'Learn New Skills. Build Your Future', 'online-learning' );
$description = esc_html__( 'Join thousands of learners and gain in-demand skills with expert-led courses in design, tech, and more.', 'online-learning' );
$button_text = esc_html__( 'Start learning today', 'online-learning' );
?>

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group">
	<!-- wp:group {"className":"animate-box","style":{"color":{"background":"#0e2075"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"blockGap":"24px"},"border":{"radius":"8px"}},"layout":{"type":"constrained","contentSize":"610px"}} -->
	<div class="wp-block-group animate-box has-background" style="border-radius:8px;background-color:#0e2075;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--30);">
		
		<!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
		<h2 class="wp-block-heading has-text-align-center has-white-color has-text-color has-link-color">
			<?php echo $title; ?>
		</h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
		<p class="has-text-align-center has-white-color has-text-color has-link-color">
			<?php echo $description; ?>
		</p>
		<!-- /wp:paragraph -->

		<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
		<div class="wp-block-buttons">
			<!-- wp:button {"textAlign":"center"} -->
			<div class="wp-block-button">
				<a class="wp-block-button__link has-text-align-center wp-element-button" href="#">
					<?php echo $button_text; ?>
				</a>
			</div>
			<!-- /wp:button -->
		</div>
		<!-- /wp:buttons -->

	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
