<?php
/**
 * Title: About Section
 * Slug: online-learning/about-section
 * Description: An about section with a headline, description, image, and call-to-action buttons.
 *
 * @package WordPress
 * @subpackage online-learning
 * @since 1.0
 */
?>

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group">
	<!-- wp:columns -->
	<div class="wp-block-columns">

		<!-- wp:column {"verticalAlignment":"center","className":"animate-box-group","style":{"spacing":{"padding":{"right":"var:preset|spacing|60"}}}} -->
		<div class="wp-block-column is-vertically-aligned-center animate-box-group" style="padding-right:var(--wp--preset--spacing--60)">

			<!-- wp:paragraph {"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"},"color":{"text":"#207dfe"},"elements":{"link":{"color":{"text":"#207dfe"}}}}} -->
			<p class="has-text-color has-link-color" style="color:#207dfe;font-style:normal;font-weight:500;text-transform:uppercase">
				<?php echo esc_html__( 'About Us', 'online-learning' ); ?>
			</p>
			<!-- /wp:paragraph -->

			<!-- wp:heading {"style":{"spacing":{"margin":{"top":"12px"}}}} -->
			<h2 class="wp-block-heading" style="margin-top:12px">
				<?php echo esc_html__( 'Real-World Knowledge. Practical Teaching. Your Growth is My Mission.', 'online-learning' ); ?>
			</h2>
			<!-- /wp:heading -->

			<!-- wp:paragraph -->
			<p>
				<?php echo esc_html__( "I'm a seasoned Product Designer and UX/UI instructor with over 30 years of industry experience. I have worked with global companies such as Google, IBM, and rapidly scaling startups across Europe.", 'online-learning' ); ?>
			</p>
			<!-- /wp:paragraph -->

			<!-- wp:heading {"level":5,"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}}} -->
			<h5 class="wp-block-heading" style="margin-top:var(--wp--preset--spacing--20)">
				<?php echo esc_html__( 'Expertise Areas', 'online-learning' ); ?>
			</h5>
			<!-- /wp:heading -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10","margin":{"top":"var:preset|spacing|20"}}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--20)">

				<?php
				$expertises = array(
					__( 'UX/UI Design for Web & Mobile', 'online-learning' ),
					__( 'Product Thinking & Design Systems', 'online-learning' ),
					__( 'Prototyping with Figma & Adobe XD', 'online-learning' ),
					__( 'Design Mentorship & Career Coaching', 'online-learning' ),
				);
				foreach ( $expertises as $text ) :
					?>
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left","verticalAlignment":"center"}} -->
				<div class="wp-block-group">
					<!-- wp:paragraph -->
					<p>	<span>✅ </span><?php echo esc_html( $text ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
				<?php endforeach; ?>

			</div>
			<!-- /wp:group -->

			<!-- wp:buttons -->
			<div class="wp-block-buttons">
				<!-- wp:button -->
				<div class="wp-block-button">
					<a class="wp-block-button__link wp-element-button" href="/contact/">
						<?php echo esc_html__( 'Contact us', 'online-learning' ); ?>
					</a>
				</div>
				<!-- /wp:button -->
			</div>
			<!-- /wp:buttons -->

		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:image {"sizeSlug":"full","linkDestination":"none","className":"animate-box"} -->
			<figure class="wp-block-image size-full animate-box">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/home-about-me.png' ); ?>" alt="<?php echo esc_attr__( 'About Image', 'online-learning' ); ?>" />
			</figure>
			<!-- /wp:image -->
		</div>
		<!-- /wp:column -->

	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
