<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package Online Learning
 * @since 1.0.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function online_learning_register_block_styles() {

		$shadow_styles = array(
			array(
				'name'  => 'thim-box-shadow',
				'label' => __( 'Box Shadow', 'online-learning' ),
			),
		);

		$core_blocks = array( 'core/columns', 'core/column', 'core/group', 'core/image' );

		foreach ( $core_blocks as $block_name ) {
			foreach ( $shadow_styles as $style ) {
				register_block_style( $block_name, $style );
			}
		}
	}
	add_action( 'init', 'online_learning_register_block_styles' );
}
