<?php
/**
 * Block Patterns
 *
 * @since 1.0.0
 */

/**
 * Registers pattern categories for Online Learning theme
 *
 * @since 1.0.0
 * @return void
 */
function online_learning_register_block_pattern_categories() {
	$block_pattern_categories = array(
		'theme' => array(
			'label' => __( 'Theme Patterns', 'online-learning' ),
		),
	);

	$block_pattern_categories = apply_filters( 'online_learning_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'online_learning_register_block_pattern_categories', 9 );
