<?php
add_action( 'admin_menu', 'online_learning_add_dashboard_page' );

function online_learning_add_dashboard_page() {
	add_menu_page(
		__( 'Online Learning', 'online-learning' ),
		__( 'Online Learning', 'online-learning' ),
		'manage_options',
		'online-learning-dashboard',
		'online_learning_render_dashboard_page',
		ONLINE_LEARNING_URI . 'assets/images/dashboard-icon.svg',
		59
	);
}

add_filter(
	'parent_file',
	function ( $parent_file ) {
		global $pagenow;
		if ( $pagenow === 'admin.php' && isset( $_GET['page'] ) && $_GET['page'] === 'online-learning-dashboard' ) {
			$parent_file = 'online-learning-dashboard';
		}
		return $parent_file;
	}
);

function online_learning_render_dashboard_page() {
	include ONLINE_LEARNING_DIR . '/inc/admin/dashboard-html.php';
}

add_action( 'admin_enqueue_scripts', 'online_learning_dashboard_assets' );
function online_learning_dashboard_assets( $hook ) {
	wp_enqueue_style(
		'thim-dashboard',
		ONLINE_LEARNING_URI . 'assets/css/admin/dashboard.css',
		array(),
		ONLINE_LEARNING_VERSION
	);
}

add_action( 'admin_bar_menu', 'online_learning_add_toolbar_link', 100 );
function online_learning_add_toolbar_link( $wp_admin_bar ) {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	$wp_admin_bar->add_node(
		array(
			'id'    => 'online-learning-dashboard',
			'title' => __( 'Online Learning', 'online-learning' ),
			'href'  => admin_url( 'admin.php?page=online-learning-dashboard' ),
			'meta'  => array(
				'class' => 'online-learning-dashboard-toolbar',
			),
		)
	);
}
