<div class="wrap online-learning-dashboard">
	<div class="online-learning-dashboard__header">
		<div class="online-learning-dashboard__header-left">
			<h1><?php esc_html_e( 'Welcome to Online Learning', 'online-learning' ); ?></h1>
			<p><?php esc_html_e( 'Online Learning is a powerful Full Site Editing, lightweight, modern free education Gutenberg WordPress theme, designed for creating a professional e-learning platform with LearnPressLMS.', 'online-learning' ); ?></p>
			<p class="sub-description"><?php esc_html_e( 'Thanks for buidling websites with us!', 'online-learning' ); ?></p>
			<p class="sub-description">
				<?php
				printf(
					esc_html__( 'Developed and supported by %s, creators of top-rated WordPress education solutions.', 'online-learning' ),
					'<a href="https://thimpress.com" target="_blank" rel="noopener noreferrer">ThimPress</a>'
				);
				?>
			</p>		
		</div>
		<div class="online-learning-dashboard__header-right">
			<img src="<?php echo esc_url( ONLINE_LEARNING_URI . 'assets/images/dashboard-illustration.png' ); ?>" alt="<?php esc_attr_e( 'Online Learning', 'online-learning' ); ?>">
		</div>
	</div>

	<div class="online-learning-dashboard__sections">
		<div class="online-learning-dashboard__section-editor">
			<div class="online-learning-dashboard__section-title">
				<h2><?php esc_html_e( 'Customize your site', 'online-learning' ); ?></h2>
				<a href="<?php echo esc_url( admin_url( 'site-editor.php' ) ); ?>" class="go-to-customize-button">
					<?php esc_html_e( 'Go to Editor', 'online-learning' ); ?>
				</a>
			</div>
			<?php
			$cards = array(
				array(
					'title' => 'Site Title and Logo',
					'link'  => 'site-editor.php?postType=wp_template_part&postId=online-learning//header&canvas=edit',
				),
				array(
					'title' => 'Add Menus',
					'link'  => 'site-editor.php?postType=wp_navigation',
				),
				array(
					'title' => 'Header Builder',
					'link'  => 'site-editor.php?postType=wp_template_part&postId=online-learning//header&canvas=edit',
				),
				array(
					'title' => 'Footer Builder',
					'link'  => 'site-editor.php?postType=wp_template_part&postId=online-learning//footer&canvas=edit',
				),
				array(
					'title' => 'Sidebar Builder',
					'link'  => 'site-editor.php?postType=wp_template_part&postId=online-learning//sidebar&canvas=edit',
				),
				array(
					'title' => 'Styles and Colors',
					'link'  => 'site-editor.php?path=/wp_global_styles',
				),
				array(
					'title' => 'Blog Options',
					'link'  => 'site-editor.php?path=/wp_template/index',
				),
				array(
					'title' => 'Templates',
					'link'  => 'site-editor.php?path=/wp_template',
				),
			);
			?>
			<div class="online-learning-dashboard__cards">
				<?php foreach ( $cards as $card ) : ?>
					<div class="online-learning-dashboard__card">
						<h3><?php echo esc_html( $card['title'] ); ?></h3>
						<a href="<?php echo esc_url( admin_url( $card['link'] ) ); ?>">
							<?php esc_html_e( 'Editor', 'textdomain' ); ?>
						</a>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<div class="online-learning-dashboard__section-plugins">
			<div class="online-learning-dashboard__section-title">
				<h2><?php esc_html_e( 'Useful plugins', 'online-learning' ); ?></h2>
			</div>
			<?php
			global $tgmpa;

			$plugin_cards = array(
				'thim-blocks'              => array(
					'title' => 'Thim Blocks',
					'icon'  => ONLINE_LEARNING_URI . 'assets/images/icon-thimblocks.png',
				),
				'learnpress'               => array(
					'title' => 'LearnPress',
					'icon'  => 'https://ps.w.org/learnpress/assets/icon-128x128.gif',
				),
				'learnpress-course-review' => array(
					'title' => 'LearnPress Course Review',
					'icon'  => 'https://ps.w.org/learnpress-course-review/assets/icon-128x128.png',
				),
				'learnpress-wishlist'      => array(
					'title' => 'LearnPress Wishlist',
					'icon'  => 'https://ps.w.org/learnpress-wishlist/assets/icon-128x128.png',
				),
				'contact-form-7'           => array(
					'title' => 'Contact Form 7',
					'icon'  => 'https://ps.w.org/contact-form-7/assets/icon-128x128.png',
				),
				'mailchimp-for-wp'         => array(
					'title' => 'Mailchimp for WordPress',
					'icon'  => 'https://ps.w.org/mailchimp-for-wp/assets/icon-128x128.png',
				),
			);

			echo '<div class="online-learning-dashboard__cards">';
			foreach ( $plugin_cards as $slug => $info ) {
				$status_html = '';

				if ( isset( $tgmpa->plugins[ $slug ] ) ) {
					$plugin = $tgmpa->plugins[ $slug ];
					$file   = $plugin['file_path'];

					if ( is_plugin_active( $file ) ) {
						$status_html = '<span class="status installed">' . esc_html__( 'Installed', 'online-learning' ) . '</span>';
					} elseif ( file_exists( WP_PLUGIN_DIR . '/' . $file ) ) {
						$url         = wp_nonce_url(
							add_query_arg(
								array(
									'plugin'         => urlencode( $file ),
									'tgmpa-activate' => 'activate-plugin',
								),
								$tgmpa->get_tgmpa_url()
							),
							'tgmpa-activate',
							'tgmpa-nonce'
						);
						$status_html = '<a class="status activate" href="' . esc_url( $url ) . '">' . esc_html__( 'Activate', 'online-learning' ) . '</a>';
					} else {
						$url         = wp_nonce_url(
							add_query_arg(
								array(
									'plugin'        => urlencode( $slug ),
									'tgmpa-install' => 'install-plugin',
								),
								$tgmpa->get_tgmpa_url()
							),
							'tgmpa-install',
							'tgmpa-nonce'
						);
						$status_html = '<a class="status install" href="' . esc_url( $url ) . '">' . esc_html__( 'Install', 'online-learning' ) . '</a>';
					}
				}

				// Render card
				?>
				<div class="online-learning-dashboard__card d-flex">
					<div class="online-learning-dashboard__card-left">
						<h3><?php echo esc_html( $info['title'] ); ?></h3>
						<?php echo $status_html; ?>
					</div>
					<div class="online-learning-dashboard__card-right">
						<img src="<?php echo esc_url( $info['icon'] ); ?>" alt="">
					</div>
				</div>
				<?php
			}
			?>
			<div class="online-learning-dashboard__card d-flex">
				<div class="online-learning-dashboard__card-left">
					<h3><?php echo esc_html( 'Premium LMS Add-ons', 'online-learning' ); ?></h3>
					<a href="https://learnpresslms.com/add-ons/" target="_blank">
						<?php esc_html_e( 'Install', 'online-learning' ); ?>
					</a>
				</div>
				<div class="online-learning-dashboard__card-right">
					<img src="https://ps.w.org/learnpress/assets/icon-128x128.gif" alt="">
				</div>
			</div>
			<?php
			echo '</div>';
			?>
		</div>
		<div class="online-learning-dashboard__section-banner">
			<div class="online-learning-dashboard__section-title">
				<h2><?php esc_html_e( 'Explore Premium Education Themes', 'online-learning' ); ?></h2>
			</div>
			<div class="online-learning-dashboard__banner-content" style="background-image: url('<?php echo esc_url( ONLINE_LEARNING_URI . 'assets/images/banner-dashboard.jpg' ); ?>');">
				<div class="online-learning-dashboard__banner-text">
					<p class="subtitle"><?php esc_html_e( 'PROVIDING AMAZING', 'online-learning' ); ?></p>
					<h3><?php esc_html_e( 'Education WordPress Theme', 'online-learning' ); ?></h3>
					<p><?php esc_html_e( 'The next level of LMS WordPress Theme. Learn anytime and anywhere.', 'online-learning' ); ?></p>
					<a href="https://1.envato.market/Ke94k9" target="_blank" class="explore-themes-button">
						<?php esc_html_e( 'Explore more Themes', 'online-learning' ); ?>
					</a>
				</div>
			</div>
		</div>
		<div class="online-learning-dashboard__section-support">
			<div class="info-box">
				<div class="info-box__content">
					<h3><?php echo esc_html__( 'Leave a review', 'online-learning' ); ?></h3>
					<p><?php echo esc_html__( 'It makes us happy to hear from our users. We would appreciate a review.', 'online-learning' ); ?></p>
					<a href="https://wordpress.org/support/theme/online-learning/reviews/#new-post" class="info-box__button">
						<?php echo esc_html__( 'Add A Review', 'online-learning' ); ?>
					</a>
				</div>
				<div class="info-box__icon">
					<svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M62.7976 15.9524L54.0476 7.20236C53.8445 6.99897 53.6032 6.83762 53.3377 6.72754C53.0721 6.61745 52.7875 6.56079 52.5 6.56079C52.2125 6.56079 51.9279 6.61745 51.6623 6.72754C51.3967 6.83762 51.1555 6.99897 50.9523 7.20236L24.7023 33.4523C24.4993 33.6556 24.3382 33.897 24.2284 34.1625C24.1187 34.4281 24.0623 34.7127 24.0625 35V43.75C24.0625 44.3302 24.293 44.8866 24.7032 45.2968C25.1134 45.707 25.6698 45.9375 26.25 45.9375H35C35.2873 45.9377 35.5719 45.8813 35.8375 45.7715C36.103 45.6618 36.3443 45.5007 36.5476 45.2977L62.7976 19.0477C63.001 18.8445 63.1624 18.6032 63.2725 18.3377C63.3825 18.0721 63.4392 17.7875 63.4392 17.5C63.4392 17.2125 63.3825 16.9279 63.2725 16.6623C63.1624 16.3968 63.001 16.1555 62.7976 15.9524ZM34.0949 41.5625H28.4375V35.9051L45.9375 18.4051L51.5949 24.0625L34.0949 41.5625ZM54.6875 20.9699L49.0301 15.3125L52.5 11.8426L58.1574 17.5L54.6875 20.9699ZM61.25 35V56.875C61.25 58.0353 60.789 59.1481 59.9686 59.9686C59.1481 60.7891 58.0353 61.25 56.875 61.25H13.125C11.9647 61.25 10.8519 60.7891 10.0314 59.9686C9.21094 59.1481 8.75 58.0353 8.75 56.875V13.125C8.75 11.9647 9.21094 10.8519 10.0314 10.0314C10.8519 9.21095 11.9647 8.75001 13.125 8.75001H35C35.5802 8.75001 36.1366 8.98048 36.5468 9.39071C36.957 9.80095 37.1875 10.3573 37.1875 10.9375C37.1875 11.5177 36.957 12.0741 36.5468 12.4843C36.1366 12.8945 35.5802 13.125 35 13.125H13.125V56.875H56.875V35C56.875 34.4198 57.1054 33.8634 57.5157 33.4532C57.9259 33.043 58.4823 32.8125 59.0625 32.8125C59.6426 32.8125 60.199 33.043 60.6093 33.4532C61.0195 33.8634 61.25 34.4198 61.25 35Z" fill="#FEC401" />
					</svg>
				</div>
			</div>
			<div class="info-box">
				<div class="info-box__content">
					<h3><?php echo esc_html__( 'Support', 'online-learning' ); ?></h3>
					<p><?php echo esc_html__( 'Got something to say? Need help?', 'online-learning' ); ?></p>
					<a href="https://wordpress.org/support/theme/online-learning/" class="info-box__button">
						<?php echo esc_html__( 'View Support Forum', 'online-learning' ); ?>
					</a>
				</div>
				<div class="info-box__icon">
					<svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M55.2043 14.9461C52.5875 12.303 49.4751 10.202 46.0452 8.76342C42.6153 7.32484 38.9353 6.57692 35.216 6.5625H35C27.4579 6.5625 20.2247 9.55859 14.8917 14.8917C9.55859 20.2247 6.5625 27.4579 6.5625 35V50.3125C6.5625 52.053 7.2539 53.7222 8.48461 54.9529C9.71532 56.1836 11.3845 56.875 13.125 56.875H17.5C19.2405 56.875 20.9097 56.1836 22.1404 54.9529C23.3711 53.7222 24.0625 52.053 24.0625 50.3125V39.375C24.0625 37.6345 23.3711 35.9653 22.1404 34.7346C20.9097 33.5039 19.2405 32.8125 17.5 32.8125H11.0359C11.4578 28.2514 13.171 23.905 15.9748 20.2828C18.7786 16.6606 22.5568 13.9126 26.8666 12.3609C31.1764 10.8093 35.8391 10.5182 40.3084 11.5219C44.7777 12.5255 48.8683 14.7823 52.1008 18.0277C56.0517 21.9989 58.4818 27.2318 58.9668 32.8125H52.5C50.7595 32.8125 49.0903 33.5039 47.8596 34.7346C46.6289 35.9653 45.9375 37.6345 45.9375 39.375V50.3125C45.9375 52.053 46.6289 53.7222 47.8596 54.9529C49.0903 56.1836 50.7595 56.875 52.5 56.875H59.0625C59.0625 58.6155 58.3711 60.2847 57.1404 61.5154C55.9097 62.7461 54.2405 63.4375 52.5 63.4375H37.1875C36.6073 63.4375 36.0509 63.668 35.6407 64.0782C35.2305 64.4884 35 65.0448 35 65.625C35 66.2052 35.2305 66.7616 35.6407 67.1718C36.0509 67.582 36.6073 67.8125 37.1875 67.8125H52.5C55.4008 67.8125 58.1828 66.6602 60.234 64.609C62.2852 62.5578 63.4375 59.7758 63.4375 56.875V35C63.4517 31.2801 62.7318 27.5939 61.319 24.1527C59.9062 20.7115 57.8283 17.5829 55.2043 14.9461ZM17.5 37.1875C18.0802 37.1875 18.6366 37.418 19.0468 37.8282C19.457 38.2384 19.6875 38.7948 19.6875 39.375V50.3125C19.6875 50.8927 19.457 51.4491 19.0468 51.8593C18.6366 52.2695 18.0802 52.5 17.5 52.5H13.125C12.5448 52.5 11.9884 52.2695 11.5782 51.8593C11.168 51.4491 10.9375 50.8927 10.9375 50.3125V37.1875H17.5ZM52.5 52.5C51.9198 52.5 51.3634 52.2695 50.9532 51.8593C50.543 51.4491 50.3125 50.8927 50.3125 50.3125V39.375C50.3125 38.7948 50.543 38.2384 50.9532 37.8282C51.3634 37.418 51.9198 37.1875 52.5 37.1875H59.0625V52.5H52.5Z" fill="#FEC401" />
					</svg>
				</div>
			</div>
		</div>
	</div>
