(function ($) {
	"use strict";

	$(document).ready(function () {
		OnlineLearning.ready();
	});

	var OnlineLearning = {
		/**
		 * Call functions when document ready
		 */
		ready: function () {
			this.header_menu();
			this.animation_box();
		},

		header_menu: function () {
			$('.wp-block-navigation-submenu__toggle').on('click', function (e) {
				e.preventDefault();

				var $submenu = $(this).closest('.wp-block-navigation-submenu');

				$submenu.toggleClass('active');
			});
		},

		animation_box: function () {
			gsap.registerPlugin(ScrollTrigger);
			$(".animate-box").each(function () {
				let $box = $(this);
				gsap.from($box, {
					opacity: 0,
					y: 50,
					duration: 1.2,
					ease: "power2.out",
					stagger: 0.2,
					scrollTrigger: {
						trigger: $box[0],
						start: "top 99%",  
						toggleActions: "play none none none", 
					},
				});
			});

			$(".animate-box-group").each(function () {
				const $children = $(this).children();
			
				$children.each(function (index) {
					gsap.from(this, {
						opacity: 0,
						y: 50,
						duration: 1.2,
						ease: "power2.out",
						delay: index * 0.3,
						scrollTrigger: {
							trigger: this,
							start: "top 99%",
							toggleActions: "play none none none",
						},
					});
				});
			});
			
			$(".animate-button-hover .wp-element-button, .animate-button-hover button, .wp-block-loginout a").on("mouseenter", function(e) {
				let rect = this.getBoundingClientRect();
				let x = e.clientX - rect.left;
				let y = e.clientY - rect.top;
				
				$(this).css("--x", x + "px");
				$(this).css("--y", y + "px");
			});
		}
	}

})(jQuery);