<?php
/**
 * Title: Courses Section
 * Slug: online-education-academy/courses-section
 * Categories: template
 */
?>

<!-- wp:group {"className":"courses-sec","style":{"spacing":{"margin":{"top":"5em","bottom":"0"},"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"layout":{"type":"constrained","contentSize":"80%","wideSize":"100%"}} -->
<div class="wp-block-group courses-sec" style="margin-top:5em;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"serv-top-title-wrap","layout":{"type":"constrained"}} -->
<div class="wp-block-group serv-top-title-wrap"><!-- wp:group {"className":"serv-top-title","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group serv-top-title"><!-- wp:html -->
<i class="fas fa-graduation-cap"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"capitalize","fontSize":"18px"}},"fontFamily":"Outfit"} -->
<p class="has-text-align-center has-outfit-font-family" style="font-size:18px;text-transform:capitalize"><?php esc_html_e('Our Cources','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","className":"serv-main-heading","style":{"spacing":{"padding":{"top":"0","bottom":"0"},"margin":{"top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"textTransform":"capitalize","fontSize":"32px"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<h2 class="wp-block-heading has-text-align-center serv-main-heading has-foreground-color has-text-color has-link-color has-outfit-font-family" style="margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0;font-size:32px;text-transform:capitalize"><?php esc_html_e('Launch a new career in as little as 6 months','online-education-academy'); ?></h2>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:columns {"className":"owl-carousel"} -->
<div class="wp-block-columns owl-carousel"><!-- wp:column {"width":"25%","className":"courses-col"} -->
<div class="wp-block-column courses-col" style="flex-basis:25%"><!-- wp:group {"className":"online-courses","style":{"spacing":{"padding":{"top":"14px","bottom":"14px","left":"14px","right":"14px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group online-courses" style="padding-top:14px;padding-right:14px;padding-bottom:14px;padding-left:14px"><!-- wp:group {"className":"img-course","layout":{"type":"constrained"}} -->
<div class="wp-block-group img-course"><!-- wp:image {"id":1687,"width":"auto","height":"300px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/hero-banner.png'); ?>" alt="" class="wp-image-1687" style="width:auto;height:300px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":1045,"width":"60px","height":"60px","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"is-style-rounded course-small-img"} -->
<figure class="wp-block-image size-full is-resized is-style-rounded course-small-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/small-img.png'); ?>" alt="Unicorn Wallpaper" class="wp-image-1045" style="object-fit:cover;width:60px;height:60px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"courses-box-content","layout":{"type":"constrained"}} -->
<div class="wp-block-group courses-box-content"><!-- wp:image {"id":2142,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/rating.png'); ?>" alt="" class="wp-image-2142" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"23px","fontStyle":"ExtraLight","fontWeight":"500","textTransform":"capitalize"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<h3 class="wp-block-heading has-foreground-color has-text-color has-link-color has-outfit-font-family" style="font-size:23px;font-style:ExtraLight;font-weight:500;text-transform:capitalize"><a href="#"><?php esc_html_e('Master Of Business Administration MBA in business management','online-education-academy'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"12px","bottom":"12px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:12px;margin-bottom:12px"><!-- wp:group {"className":"course-duration","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group course-duration"><!-- wp:html -->
<i class="fas fa-clock"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('2h25min','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"lp-meta-students total-student","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group lp-meta-students total-student"><!-- wp:html -->
<i class="fas fa-user"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('50 Student','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#c4c4c4"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="margin-top:0;margin-bottom:0;background-color:#c4c4c4;color:#c4c4c4"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"courses-info","style":{"spacing":{"margin":{"top":"10px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
<div class="wp-block-group courses-info" style="margin-top:10px;margin-bottom:0px"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"className":"course-price-label","style":{"typography":{"textTransform":"capitalize","fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="course-price-label has-outfit-font-family" style="font-size:17px;font-style:Thin;font-weight:300;text-transform:capitalize"><?php esc_html_e('Price','online-education-academy'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"course-price-value","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"20px","fontStyle":"Thin","fontWeight":"600"}},"fontFamily":"Outfit"} -->
<p class="course-price-value has-outfit-font-family" style="margin-top:0;margin-bottom:0;font-size:20px;font-style:Thin;font-weight:600"><?php esc_html_e('$250.00','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"className":"course-cat","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontStyle":"Thin","fontWeight":"400","fontSize":"17px"},"spacing":{"padding":{"top":"6px","bottom":"6px","left":"15px","right":"15px"},"margin":{"top":"0","bottom":"0","left":"0","right":"0"}},"border":{"radius":{"topLeft":"30px","topRight":"30px","bottomLeft":"30px","bottomRight":"30px"}},"color":{"background":"#efeeee"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<p class="course-cat has-foreground-color has-text-color has-background has-link-color has-outfit-font-family" style="border-top-left-radius:30px;border-top-right-radius:30px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;background-color:#efeeee;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:6px;padding-right:15px;padding-bottom:6px;padding-left:15px;font-size:17px;font-style:Thin;font-weight:400"><a href="#"><?php esc_html_e('Beginner','online-education-academy'); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%","className":"courses-col"} -->
<div class="wp-block-column courses-col" style="flex-basis:25%"><!-- wp:group {"className":"online-courses","style":{"spacing":{"padding":{"top":"14px","bottom":"14px","left":"14px","right":"14px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group online-courses" style="padding-top:14px;padding-right:14px;padding-bottom:14px;padding-left:14px"><!-- wp:group {"className":"img-course","layout":{"type":"constrained"}} -->
<div class="wp-block-group img-course"><!-- wp:image {"id":1687,"width":"auto","height":"300px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/course-img2.png'); ?>" alt="" class="wp-image-1687" style="width:auto;height:300px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":1045,"width":"60px","height":"60px","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"is-style-rounded course-small-img"} -->
<figure class="wp-block-image size-full is-resized is-style-rounded course-small-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/small-img.png'); ?>" alt="Unicorn Wallpaper" class="wp-image-1045" style="object-fit:cover;width:60px;height:60px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"courses-box-content","layout":{"type":"constrained"}} -->
<div class="wp-block-group courses-box-content"><!-- wp:image {"id":2142,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/rating.png'); ?>" alt="" class="wp-image-2142" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"23px","fontStyle":"ExtraLight","fontWeight":"500","textTransform":"capitalize"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<h3 class="wp-block-heading has-foreground-color has-text-color has-link-color has-outfit-font-family" style="font-size:23px;font-style:ExtraLight;font-weight:500;text-transform:capitalize"><a href="#"><?php esc_html_e('Bachelor Of Science In Data Science And AI','online-education-academy'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"12px","bottom":"12px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:12px;margin-bottom:12px"><!-- wp:group {"className":"course-duration","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group course-duration"><!-- wp:html -->
<i class="fas fa-clock"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('2h25min','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"lp-meta-students total-student","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group lp-meta-students total-student"><!-- wp:html -->
<i class="fas fa-user"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('50 Student','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#c4c4c4"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="margin-top:0;margin-bottom:0;background-color:#c4c4c4;color:#c4c4c4"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"courses-info","style":{"spacing":{"margin":{"top":"10px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
<div class="wp-block-group courses-info" style="margin-top:10px;margin-bottom:0px"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"className":"course-price-label","style":{"typography":{"textTransform":"capitalize","fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="course-price-label has-outfit-font-family" style="font-size:17px;font-style:Thin;font-weight:300;text-transform:capitalize"><?php esc_html_e('Price','online-education-academy'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"course-price-value","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"20px","fontStyle":"Thin","fontWeight":"600"}},"fontFamily":"Outfit"} -->
<p class="course-price-value has-outfit-font-family" style="margin-top:0;margin-bottom:0;font-size:20px;font-style:Thin;font-weight:600"><?php esc_html_e('$430.00','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"className":"course-cat","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontStyle":"Thin","fontWeight":"400","fontSize":"17px"},"spacing":{"padding":{"top":"6px","bottom":"6px","left":"15px","right":"15px"},"margin":{"top":"0","bottom":"0","left":"0","right":"0"}},"border":{"radius":{"topLeft":"30px","topRight":"30px","bottomLeft":"30px","bottomRight":"30px"}},"color":{"background":"#efeeee"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<p class="course-cat has-foreground-color has-text-color has-background has-link-color has-outfit-font-family" style="border-top-left-radius:30px;border-top-right-radius:30px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;background-color:#efeeee;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:6px;padding-right:15px;padding-bottom:6px;padding-left:15px;font-size:17px;font-style:Thin;font-weight:400"><a href="#"><?php esc_html_e('Beginner','online-education-academy'); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%","className":"courses-col"} -->
<div class="wp-block-column courses-col" style="flex-basis:25%"><!-- wp:group {"className":"online-courses","style":{"spacing":{"padding":{"top":"14px","bottom":"14px","left":"14px","right":"14px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group online-courses" style="padding-top:14px;padding-right:14px;padding-bottom:14px;padding-left:14px"><!-- wp:group {"className":"img-course","layout":{"type":"constrained"}} -->
<div class="wp-block-group img-course"><!-- wp:image {"id":1687,"width":"auto","height":"300px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/course-img3.png'); ?>" alt="" class="wp-image-1687" style="width:auto;height:300px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":1045,"width":"60px","height":"60px","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"is-style-rounded course-small-img"} -->
<figure class="wp-block-image size-full is-resized is-style-rounded course-small-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/small-img.png'); ?>" alt="Unicorn Wallpaper" class="wp-image-1045" style="object-fit:cover;width:60px;height:60px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"courses-box-content","layout":{"type":"constrained"}} -->
<div class="wp-block-group courses-box-content"><!-- wp:image {"id":2142,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/rating.png'); ?>" alt="" class="wp-image-2142" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"23px","fontStyle":"ExtraLight","fontWeight":"500","textTransform":"capitalize"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<h3 class="wp-block-heading has-foreground-color has-text-color has-link-color has-outfit-font-family" style="font-size:23px;font-style:ExtraLight;font-weight:500;text-transform:capitalize"><a href="#"><?php esc_html_e('A Master Degree That Integrates International Relations Security','online-education-academy'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"12px","bottom":"12px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:12px;margin-bottom:12px"><!-- wp:group {"className":"course-duration","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group course-duration"><!-- wp:html -->
<i class="fas fa-clock"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('2h25min','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"lp-meta-students total-student","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group lp-meta-students total-student"><!-- wp:html -->
<i class="fas fa-user"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('50 Student','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#c4c4c4"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="margin-top:0;margin-bottom:0;background-color:#c4c4c4;color:#c4c4c4"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"courses-info","style":{"spacing":{"margin":{"top":"10px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
<div class="wp-block-group courses-info" style="margin-top:10px;margin-bottom:0px"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"className":"course-price-label","style":{"typography":{"textTransform":"capitalize","fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="course-price-label has-outfit-font-family" style="font-size:17px;font-style:Thin;font-weight:300;text-transform:capitalize"><?php esc_html_e('Price','online-education-academy'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"course-price-value","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"20px","fontStyle":"Thin","fontWeight":"600"}},"fontFamily":"Outfit"} -->
<p class="course-price-value has-outfit-font-family" style="margin-top:0;margin-bottom:0;font-size:20px;font-style:Thin;font-weight:600"><?php esc_html_e('$230.00','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"className":"course-cat","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontStyle":"Thin","fontWeight":"400","fontSize":"17px"},"spacing":{"padding":{"top":"6px","bottom":"6px","left":"15px","right":"15px"},"margin":{"top":"0","bottom":"0","left":"0","right":"0"}},"border":{"radius":{"topLeft":"30px","topRight":"30px","bottomLeft":"30px","bottomRight":"30px"}},"color":{"background":"#efeeee"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<p class="course-cat has-foreground-color has-text-color has-background has-link-color has-outfit-font-family" style="border-top-left-radius:30px;border-top-right-radius:30px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;background-color:#efeeee;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:6px;padding-right:15px;padding-bottom:6px;padding-left:15px;font-size:17px;font-style:Thin;font-weight:400"><a href="#"><?php esc_html_e('Beginner','online-education-academy'); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%","className":"courses-col"} -->
<div class="wp-block-column courses-col" style="flex-basis:25%"><!-- wp:group {"className":"online-courses","style":{"spacing":{"padding":{"top":"14px","bottom":"14px","left":"14px","right":"14px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group online-courses" style="padding-top:14px;padding-right:14px;padding-bottom:14px;padding-left:14px"><!-- wp:group {"className":"img-course","layout":{"type":"constrained"}} -->
<div class="wp-block-group img-course"><!-- wp:image {"id":1687,"width":"auto","height":"300px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/course-img3.png'); ?>" alt="" class="wp-image-1687" style="width:auto;height:300px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":1045,"width":"60px","height":"60px","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"is-style-rounded course-small-img"} -->
<figure class="wp-block-image size-full is-resized is-style-rounded course-small-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/small-img.png'); ?>" alt="Unicorn Wallpaper" class="wp-image-1045" style="object-fit:cover;width:60px;height:60px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"courses-box-content","layout":{"type":"constrained"}} -->
<div class="wp-block-group courses-box-content"><!-- wp:image {"id":2142,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/rating.png'); ?>" alt="" class="wp-image-2142" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"23px","fontStyle":"ExtraLight","fontWeight":"500","textTransform":"capitalize"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<h3 class="wp-block-heading has-foreground-color has-text-color has-link-color has-outfit-font-family" style="font-size:23px;font-style:ExtraLight;font-weight:500;text-transform:capitalize"><a href="#"><?php esc_html_e('Bachelor Of Journalism And Mass Communication','online-education-academy'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"12px","bottom":"12px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:12px;margin-bottom:12px"><!-- wp:group {"className":"course-duration","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group course-duration"><!-- wp:html -->
<i class="fas fa-clock"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('2h25min','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"lp-meta-students total-student","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group lp-meta-students total-student"><!-- wp:html -->
<i class="fas fa-user"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('50 Student','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#c4c4c4"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="margin-top:0;margin-bottom:0;background-color:#c4c4c4;color:#c4c4c4"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"courses-info","style":{"spacing":{"margin":{"top":"10px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
<div class="wp-block-group courses-info" style="margin-top:10px;margin-bottom:0px"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"className":"course-price-label","style":{"typography":{"textTransform":"capitalize","fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="course-price-label has-outfit-font-family" style="font-size:17px;font-style:Thin;font-weight:300;text-transform:capitalize"><?php esc_html_e('Price','online-education-academy'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"course-price-value","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"20px","fontStyle":"Thin","fontWeight":"600"}},"fontFamily":"Outfit"} -->
<p class="course-price-value has-outfit-font-family" style="margin-top:0;margin-bottom:0;font-size:20px;font-style:Thin;font-weight:600"><?php esc_html_e('$130.00','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"className":"course-cat","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontStyle":"Thin","fontWeight":"400","fontSize":"17px"},"spacing":{"padding":{"top":"6px","bottom":"6px","left":"15px","right":"15px"},"margin":{"top":"0","bottom":"0","left":"0","right":"0"}},"border":{"radius":{"topLeft":"30px","topRight":"30px","bottomLeft":"30px","bottomRight":"30px"}},"color":{"background":"#efeeee"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<p class="course-cat has-foreground-color has-text-color has-background has-link-color has-outfit-font-family" style="border-top-left-radius:30px;border-top-right-radius:30px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;background-color:#efeeee;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:6px;padding-right:15px;padding-bottom:6px;padding-left:15px;font-size:17px;font-style:Thin;font-weight:400"><a href="#"><?php esc_html_e('Beginner','online-education-academy'); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%","className":"courses-col"} -->
<div class="wp-block-column courses-col" style="flex-basis:25%"><!-- wp:group {"className":"online-courses","style":{"spacing":{"padding":{"top":"14px","bottom":"14px","left":"14px","right":"14px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group online-courses" style="padding-top:14px;padding-right:14px;padding-bottom:14px;padding-left:14px"><!-- wp:group {"className":"img-course","layout":{"type":"constrained"}} -->
<div class="wp-block-group img-course"><!-- wp:image {"id":1687,"width":"auto","height":"300px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/course-img2.png'); ?>" alt="" class="wp-image-1687" style="width:auto;height:300px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":1045,"width":"60px","height":"60px","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"is-style-rounded course-small-img"} -->
<figure class="wp-block-image size-full is-resized is-style-rounded course-small-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/small-img.png'); ?>" alt="Unicorn Wallpaper" class="wp-image-1045" style="object-fit:cover;width:60px;height:60px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"courses-box-content","layout":{"type":"constrained"}} -->
<div class="wp-block-group courses-box-content"><!-- wp:image {"id":2142,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/rating.png'); ?>" alt="" class="wp-image-2142" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontSize":"23px","fontStyle":"ExtraLight","fontWeight":"500","textTransform":"capitalize"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<h3 class="wp-block-heading has-foreground-color has-text-color has-link-color has-outfit-font-family" style="font-size:23px;font-style:ExtraLight;font-weight:500;text-transform:capitalize"><a href="#"><?php esc_html_e('Master Of Business Administration MBA in business management','online-education-academy'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"12px","bottom":"12px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:12px;margin-bottom:12px"><!-- wp:group {"className":"course-duration","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group course-duration"><!-- wp:html -->
<i class="fas fa-clock"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('2h25min','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"className":"lp-meta-students total-student","style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group lp-meta-students total-student"><!-- wp:html -->
<i class="fas fa-user"></i>
<!-- /wp:html -->

<!-- wp:paragraph {"style":{"color":{"text":"#3b3a3a"},"elements":{"link":{"color":{"text":"#3b3a3a"}}},"typography":{"fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="has-text-color has-link-color has-outfit-font-family" style="color:#3b3a3a;font-size:17px;font-style:Thin;font-weight:300"><?php esc_html_e('50 Student','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-wide","style":{"color":{"background":"#c4c4c4"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<hr class="wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide" style="margin-top:0;margin-bottom:0;background-color:#c4c4c4;color:#c4c4c4"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"courses-info","style":{"spacing":{"margin":{"top":"10px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
<div class="wp-block-group courses-info" style="margin-top:10px;margin-bottom:0px"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"className":"course-price-label","style":{"typography":{"textTransform":"capitalize","fontSize":"17px","fontStyle":"Thin","fontWeight":"300"}},"fontFamily":"Outfit"} -->
<p class="course-price-label has-outfit-font-family" style="font-size:17px;font-style:Thin;font-weight:300;text-transform:capitalize"><?php esc_html_e('Price','online-education-academy'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"course-price-value","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"20px","fontStyle":"Thin","fontWeight":"600"}},"fontFamily":"Outfit"} -->
<p class="course-price-value has-outfit-font-family" style="margin-top:0;margin-bottom:0;font-size:20px;font-style:Thin;font-weight:600"><?php esc_html_e('$330.00','online-education-academy'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"className":"course-cat","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontStyle":"Thin","fontWeight":"400","fontSize":"17px"},"spacing":{"padding":{"top":"6px","bottom":"6px","left":"15px","right":"15px"},"margin":{"top":"0","bottom":"0","left":"0","right":"0"}},"border":{"radius":{"topLeft":"30px","topRight":"30px","bottomLeft":"30px","bottomRight":"30px"}},"color":{"background":"#efeeee"}},"textColor":"foreground","fontFamily":"Outfit"} -->
<p class="course-cat has-foreground-color has-text-color has-background has-link-color has-outfit-font-family" style="border-top-left-radius:30px;border-top-right-radius:30px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;background-color:#efeeee;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:6px;padding-right:15px;padding-bottom:6px;padding-left:15px;font-size:17px;font-style:Thin;font-weight:400"><a href="#"><?php esc_html_e('Beginner','online-education-academy'); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
