<?php
/**
 * Online Education Academy: Block Patterns
 *
 * @since Online Education Academy 1.0
 */

 /**
  * Get patterns content.
  *
  * @param string $file_name Filename.
  * @return string
  */
function online_education_academy_get_pattern_content( $file_name ) {
	ob_start();
	include get_theme_file_path( '/patterns/' . $file_name . '.php' );
	$output = ob_get_contents();
	ob_end_clean();
	return $output;
}

/**
 * Registers block patterns and categories.
 *
 * @since Online Education Academy 1.0
 *
 * @return void
 */
function online_education_academy_register_block_patterns() {

	$patterns = array(
		'header-default' => array(
			'title'      => __( 'Default header', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-headers' ),
			'blockTypes' => array( 'parts/header' ),
		),
		'footer-default' => array(
			'title'      => __( 'Default footer', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-footers' ),
			'blockTypes' => array( 'parts/footer' ),
		),
		'home-banner' => array(
			'title'      => __( 'Home Banner', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-banner' ),
		),
		'courses-section' => array(
			'title'      => __( 'Courses Section', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-courses-section' ),
		),
		'counter-section' => array(
			'title'      => __( 'Counter Section', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-counter-section' ),
		),
		'latest-blog-section' => array(
			'title'      => __( 'Latest Blog Section', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-latest-blog-section' ),
		),
		'primary-sidebar' => array(
			'title'    => __( 'Primary Sidebar', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-sidebars' ),
		),
		'hidden-404' => array(
			'title'    => __( '404 content', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-pages' ),
		),
		'post-listing-single-column' => array(
			'title'    => __( 'Post Single Column', 'online-education-academy' ),
			//'inserter' => false,
			'categories' => array( 'online-education-academy-query' ),
		),
		'post-listing-two-column' => array(
			'title'    => __( 'Post Two Column', 'online-education-academy' ),
			//'inserter' => false,
			'categories' => array( 'online-education-academy-query' ),
		),
		'post-listing-three-column' => array(
			'title'    => __( 'Post Three Column', 'online-education-academy' ),
			//'inserter' => false,
			'categories' => array( 'online-education-academy-query' ),
		),
		'post-listing-four-column' => array(
			'title'    => __( 'Post Four Column', 'online-education-academy' ),
			//'inserter' => false,
			'categories' => array( 'online-education-academy-query' ),
		),
		'feature-post-column' => array(
			'title'    => __( 'Feature Post Column', 'online-education-academy' ),
			//'inserter' => false,
			'categories' => array( 'online-education-academy-query' ),
		),
		'comment-section-1' => array(
			'title'    => __( 'Comment Section 1', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-comment-sections' ),
		),
		'cover-with-post-title' => array(
			'title'    => __( 'Cover With Post Title', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-banner-sections' ),
		),
		'theme-button' => array(
			'title'    => __( 'Theme Button', 'online-education-academy' ),
			'categories' => array( 'online-education-academy-theme-button' ),
		),
	);

	$block_pattern_categories = array(
		'online-education-academy-footers' => array( 'label' => __( 'Footers Section', 'online-education-academy' ) ),
		'online-education-academy-headers' => array( 'label' => __( 'Headers Section', 'online-education-academy' ) ),
		'online-education-academy-pages'   => array( 'label' => __( 'Pages', 'online-education-academy' ) ),
		'online-education-academy-query'   => array( 'label' => __( 'Query', 'online-education-academy' ) ),
		'online-education-academy-sidebars'   => array( 'label' => __( 'Sidebars', 'online-education-academy' ) ),
		'online-education-academy-banner'   => array( 'label' => __( 'Slider Section', 'online-education-academy' ) ),
		'online-education-academy-courses-section'   => array( 'label' => __( 'Courses Section', 'online-education-academy' ) ),
		'online-education-academy-counter-section'   => array( 'label' => __( 'Counter Section', 'online-education-academy' ) ),
		'online-education-academy-latest-blog-section'   => array( 'label' => __( 'Latest Blog Section', 'online-education-academy' ) ),
		'online-education-academy-comment-section'   => array( 'label' => __( 'Comment Section', 'online-education-academy' ) ),
		'online-education-academy-theme-button'   => array( 'label' => __( 'Theme Button Section', 'online-education-academy' ) ),
	);

	/**
	 * Filters the theme block pattern categories.
	 *
	 * @since Online Education Academy 1.0
	 *
	 * @param array[] $block_pattern_categories {
	 *     An associative array of block pattern categories, keyed by category name.
	 *
	 *     @type array[] $properties {
	 *         An array of block category properties.
	 *
	 *         @type string $label A human-readable label for the pattern category.
	 *     }
	 * }
	 */
	$block_pattern_categories = apply_filters( 'online_education_academy_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}

	/**
	 * Filters the theme block patterns.
	 *
	 * @since Online Education Academy 1.0
	 *
	 * @param array $block_patterns List of block patterns by name.
	 */
	$patterns = apply_filters( 'online_education_academy_block_patterns', $patterns );

	foreach ( $patterns as $block_pattern => $pattern ) {
		$pattern['content'] = online_education_academy_get_pattern_content( $block_pattern );
		register_block_pattern(
			'online-education-academy/' . $block_pattern,
			$pattern
		);
	}
}
add_action( 'init', 'online_education_academy_register_block_patterns', 9 );
