<?php
/**
 * Online Education Academy functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Online Education Academy
 */

if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'ONLINE_EDUCATION_ACADEMY_VERSION', wp_get_theme()->get( 'Version' ) );
}

if ( ! function_exists( 'online_education_academy_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function online_education_academy_setup() {

		load_theme_textdomain( 'online-education-academy', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'woocommerce' );

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style.css' );

		// Add support for core custom logo.
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 192,
				'width'       => 192,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		// Experimental support for adding blocks inside nav menus
		add_theme_support( 'block-nav-menus' );

		// Add support for experimental link color control.
		add_theme_support( 'experimental-link-color' );

	}
endif;
add_action( 'after_setup_theme', 'online_education_academy_setup' );

function online_education_academy_scripts() {
    wp_enqueue_style('online-education-academy-style', get_stylesheet_uri(), array() );
    wp_enqueue_script('jquery-wow', get_template_directory_uri() . '/js/wow.js', array('jquery'));
    wp_enqueue_style('animate-css', get_template_directory_uri() . '/css/animate.css');

	//font-awesome
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/font-awesome/css/all.css', array(), '6.7.0' );

    wp_enqueue_style( 'owl.carousel-style', get_template_directory_uri().'/css/owl.carousel.css', array(), ONLINE_EDUCATION_ACADEMY_VERSION );
	wp_enqueue_script( 'owl.carousel-js', get_template_directory_uri(). '/js/owl.carousel.js', array('jquery') ,ONLINE_EDUCATION_ACADEMY_VERSION,true);

    // Custom scripts should depend on JS and jQuery
    wp_enqueue_script('online-education-academy-custom-scripts', get_template_directory_uri() . '/js/custom.js',  array('jquery'),'' ,true );
    wp_style_add_data( 'online-education-academy-style', 'rtl', 'replace' );
}
add_action( 'wp_enqueue_scripts', 'online_education_academy_scripts' );

/**
 * Enqueue block editor style
 */
function online_education_academy_block_editor_styles() {

	wp_enqueue_style( 'online-education-academy-block-patterns-style-editor', get_theme_file_uri( '/css/block-editor.css' ), false, '1.0', 'all' );
}
add_action( 'enqueue_block_editor_assets', 'online_education_academy_block_editor_styles' );


function online_education_academy_init_setup() {

	require_once get_theme_file_path( '/inc/customizer.php' );

	// Add block patterns
	require get_template_directory() . '/inc/block-patterns.php';

	/**
     * Demo Import
     */
    require get_parent_theme_file_path( '/inc/get-started/demo-import-settings.php' );

    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_FREE_THEME_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_FREE_THEME_URL', 'https://www.seothemesexpert.com/products/online-education-academy-theme' );
    }
    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_PRO_THEME_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_PRO_THEME_URL', 'https://www.seothemesexpert.com/products/education-wordpress-theme' );
    }
    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_FREE_DOC_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_FREE_DOC_URL', 'https://demo.seothemesexpert.com/documentation/online-education-academy-free/' );
    }
    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_DEMO_THEME_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_DEMO_THEME_URL', 'https://demo.seothemesexpert.com/education/online-education-academy-pro/' );
    }
    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_RATE_THEME_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_RATE_THEME_URL', 'https://wordpress.org/support/theme/online-education-academy/reviews/' );
    }
    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_SUPPORT_THEME_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_SUPPORT_THEME_URL', 'https://wordpress.org/support/theme/online-education-academy/' );
    }
    if ( ! defined( 'ONLINE_EDUCATION_ACADEMY_THEME_BUNDLE_URL' ) ) {
        define( 'ONLINE_EDUCATION_ACADEMY_THEME_BUNDLE_URL', 'https://www.seothemesexpert.com/products/wordpress-theme-bundle' );
    }
}
add_action( 'after_setup_theme', 'online_education_academy_init_setup' );


// Show Admin Notice
function online_education_academy_promo_notice() {
    if (get_option('online_education_academy_notice_dismissed')) {
        return;
    }

    if (isset($_GET['page']) && $_GET['page'] === 'onlineeducationacademy-wizard') {
        return;
    }

    $online_education_academy_theme = wp_get_theme();
    $online_education_academy_theme_title = $online_education_academy_theme->get( 'Name' );
    $online_education_academy_theme_version = $online_education_academy_theme->get( 'Version' );

    ?>
    <div class="notice online-education-academy-notice is-dismissible">
        <div>
            <h3>
                <span><?php echo esc_html( '(Version: ' . $online_education_academy_theme_version . ')' ); ?></span><br>
                <?php esc_html_e( 'Thank you for choosing,', 'online-education-academy'); ?>
                <?php echo esc_html( $online_education_academy_theme_title ); ?> <?php esc_html_e( '!!!', 'online-education-academy'); ?>
            </h3>
            <p><?php esc_html_e( 'Welcome! You can now easily start building your website using our beautiful and user-friendly themes. No need to worry about setup — with our one-click demo importer, your site can look just like the demo in minutes. All the tools and information you need to get started are right here!', 'online-education-academy'); ?></p>
            <a class="button button-primary online-education-academy-buy-now" href="<?php echo esc_url(admin_url('themes.php?page=onlineeducationacademy-wizard')); ?>" target="_blank">
                <?php esc_html_e( 'Get Started', 'online-education-academy') ?>
            </a>
            <a class="button button-primary online-education-academy-bundle-button" target="_blank" href="<?php echo esc_url( ONLINE_EDUCATION_ACADEMY_THEME_BUNDLE_URL ); ?>">
                <?php echo esc_html__( 'Get All 50+ Themes @ $79', 'online-education-academy' ); ?>
            </a>
        </div>
        <div class="online-education-academy-image-wrap">
            <img src="<?php echo esc_url(get_stylesheet_directory_uri() . '/screenshot.png'); ?>">
        </div>
        <canvas id="online-education-academy-notice-confetti"></canvas>
    </div>
    <?php
}
add_action('admin_notices', 'online_education_academy_promo_notice');

add_action('wp_ajax_online_education_academy_dismiss_notice', 'online_education_academy_dismiss_notice');
function online_education_academy_dismiss_notice() {
    update_option('online_education_academy_notice_dismissed', true);
    wp_send_json_success();
}

add_action('after_switch_theme', 'online_education_academy_reset_notice_on_activation');
function online_education_academy_reset_notice_on_activation() {
    delete_option('online_education_academy_notice_dismissed');
}

function online_education_academy_enqueue_admin_assets() {
    wp_enqueue_script(
        'online-education-academy-confetti',
        get_template_directory_uri() . '/inc/get-started/assets/js/confetti/confetti.min.js',
        ['jquery'],
        null,
        true
    );

    wp_enqueue_script(
        'online-education-academy-notice-confetti-js',
        get_template_directory_uri() . '/inc/get-started/assets/js/plugin-update-notice.js',
        ['online-education-academy-confetti'],
        null,
        true
    );

    wp_enqueue_script(
        'online-education-academy-notice-dismiss',
        get_template_directory_uri() . '/inc/get-started/assets/js/notice-dismiss.js',
        ['jquery'],
        null,
        true
    );
}
add_action('admin_enqueue_scripts', 'online_education_academy_enqueue_admin_assets');