<?php

/**
 *
 * @package OneDream
 *
 */
function onedream_enqueue_comments_reply() {
    if (get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

add_action('comment_form_before', 'onedream_enqueue_comments_reply');


add_action('customize_register', 'onedream_customize_register_custom_controls', 9);

function onedream_customize_register_custom_controls($wp_customize) {
    get_template_part('lib/onedream', 'sectionpro');
}

if (!function_exists('onedream_sanitize_page')) :

    function onedream_sanitize_page($page_id, $setting) {
        // Ensure $input is an absolute integer.
        $page_id = absint($page_id);
        // If $page_id is an ID of a published page, return it; otherwise, return the default.
        return ( 'publish' === get_post_status($page_id) ? $page_id : $setting->default );
    }

endif;

function onedream_customize_register($wp_customize) {

    // Register custom section types.
    $wp_customize->register_section_type('onedream_Customize_Section_Pro');

    // Register sections.
    $wp_customize->add_section(new onedream_Customize_Section_Pro(
                    $wp_customize,
                    'theme_go_pro',
                    array(
                'priority' => 1,
                'title'    => esc_html__('OneDream Pro', 'onedream'),
                'pro_text' => esc_html__('Upgrade To Pro', 'onedream'),
                'pro_url'  => 'https://themestulip.com/themes/onedream-corporate-wordpress-theme/',
                    )
    ));


    $wp_customize->add_section('onedream_header', array(
        'title'       => esc_html__('OneDream Header Phone and Address', 'onedream'),
        'description' => '',
        'priority'    => 30,
    ));

    $wp_customize->add_section('onedream_social', array(
        'title'       => esc_html__('OneDream Social Link', 'onedream'),
        'description' => '',
        'priority'    => 35,
    ));

    //  =============================
    //  = Text Input phone number                =
    //  =============================
    $wp_customize->add_setting('onedream_phone', array(
        'default'           => '',
        'sanitize_callback' => 'onedream_sanitize_phone_number'
    ));

    $wp_customize->add_control('onedream_phone', array(
        'label'   => esc_html__('Phone Number', 'onedream'),
        'section' => 'onedream_header',
        'setting' => 'onedream_phone',
        'type'    => 'text'
    ));

    //  =============================
    //  = Text Input Email                =
    //  =============================
    $wp_customize->add_setting('onedream_address', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_textarea_field'
    ));

    $wp_customize->add_control('onedream_address', array(
        'label'   => esc_html__('Address', 'onedream'),
        'section' => 'onedream_header',
        'setting' => 'onedream_address',
        'type'    => 'textarea'
    ));


    //  =============================
    //  = Text Input facebook                =
    //  =============================
    $wp_customize->add_setting('onedream_fb', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('onedream_fb', array(
        'label'   => esc_html__('Facebook', 'onedream'),
        'section' => 'onedream_social',
        'setting' => 'onedream_fb',
    ));
    //  =============================
    //  = Text Input Twitter                =
    //  =============================
    $wp_customize->add_setting('onedream_twitter', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('onedream_twitter', array(
        'label'   => esc_html__('Twitter', 'onedream'),
        'section' => 'onedream_social',
        'setting' => 'onedream_twitter',
    ));
    //  =============================
    //  = Text Input googleplus                =
    //  =============================
    $wp_customize->add_setting('onedream_glplus', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('onedream_glplus', array(
        'label'   => esc_html__('Google Plus', 'onedream'),
        'section' => 'onedream_social',
        'setting' => 'onedream_glplus',
    ));
    //  =============================
    //  = Text Input linkedin                =
    //  =============================
    $wp_customize->add_setting('onedream_in', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('onedream_in', array(
        'label'   => esc_html__('Linkedin', 'onedream'),
        'section' => 'onedream_social',
        'setting' => 'onedream_in',
    ));


    //  =============================
    //  = slider section              =
    //  =============================
    $wp_customize->add_section('onedream_banner', array(
        'title'       => esc_html__('OneDream Home Page slider', 'onedream'),
        'description' => esc_html__('banner Size Should be ( 1600x550 ).', 'onedream'),
        'priority'    => 36,
    ));

    $wp_customize->add_setting('banner1', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('banner1', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for banner first:', 'onedream'),
        'section' => 'onedream_banner'
    ));

    $wp_customize->add_setting('banner2', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('banner2', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for banner second:', 'onedream'),
        'section' => 'onedream_banner'
    ));

    $wp_customize->add_setting('banner3', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('banner3', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for banner third:', 'onedream'),
        'section' => 'onedream_banner'
    ));

//  =============================
    //  = box section              =
    //  =============================
    $wp_customize->add_section('onedream_box', array(
        'title'       => esc_html__('OneDream HomePage Three Box', 'onedream'),
        'description' => esc_html__('Upload image, it will auto crop with 400*250.', 'onedream'),
        'priority'    => 36,
    ));

    $wp_customize->add_setting('box1', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('box1', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for box first:', 'onedream'),
        'section' => 'onedream_box'
    ));

    $wp_customize->add_setting('box2', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('box2', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for box second:', 'onedream'),
        'section' => 'onedream_box'
    ));

    $wp_customize->add_setting('box3', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('box3', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for box third:', 'onedream'),
        'section' => 'onedream_box'
    ));

//  =============================
    //  = box section              =
    //  =============================
    $wp_customize->add_section('onedream_welcome_to_homepage', array(
        'title'       => esc_html__('OneDream HomePage welcome section', 'onedream'),
        'description' => esc_html__('It will shows on homepage', 'onedream'),
        'priority'    => 36,
    ));

    $wp_customize->add_setting('welcome_section', array(
        'default'           => '0',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'onedream_sanitize_page'
    ));

    $wp_customize->add_control('welcome_section', array(
        'type'    => 'dropdown-pages',
        'label'   => esc_html__('Select page for homepage welcome:', 'onedream'),
        'section' => 'onedream_welcome_to_homepage'
    ));


    //  =============================
    //  = Footer              =
    //  =============================

    $wp_customize->add_section('onedream_footer', array(
        'title'       => esc_html__('OneDream Footer', 'onedream'),
        'description' => '',
        'priority'    => 37,
    ));

    // Footer design and developed
    $wp_customize->add_setting('onedream_design', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_textarea_field'
    ));

    $wp_customize->add_control('onedream_design', array(
        'label'   => esc_html__('Design and developed', 'onedream'),
        'section' => 'onedream_footer',
        'setting' => 'onedream_design',
        'type'    => 'textarea'
    ));
    // Footer copyright
    $wp_customize->add_setting('onedream_copyright', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_textarea_field'
    ));

    $wp_customize->add_control('onedream_copyright', array(
        'label'   => esc_html__('Copyright', 'onedream'),
        'section' => 'onedream_footer',
        'setting' => 'onedream_copyright',
        'type'    => 'textarea'
    ));
}

add_action('customize_register', 'onedream_customize_register');

function onedream_sanitize_phone_number($phone) {
    return preg_replace('/[^\d+]/', '', $phone);
}
