<?php
/**
 * @package OneDream
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <?php if (is_singular() && pings_open(get_queried_object())) : ?>
            <link rel="pingback" href="<?php echo esc_url(get_bloginfo('pingback_url')); ?>">
        <?php endif; ?>
        <?php wp_head(); ?>

    </head>
    <body <?php body_class(); ?>>
        <?php
        if (function_exists('wp_body_open')) {
            wp_body_open();
        } else {
            do_action('wp_body_open');
        }
        $onedream_fb      = get_theme_mod('onedream_fb');
        $onedream_twitter = get_theme_mod('onedream_twitter');
        $onedream_in      = get_theme_mod('onedream_in');
        $onedream_glplus  = get_theme_mod('onedream_glplus');
        $onedream_phone   = get_theme_mod('onedream_phone');
        $onedream_address = get_theme_mod('onedream_address');
        ?>
        <a class = "skip-link screen-reader-text" href = "#contentdiv">
            <?php esc_html_e('Skip to content', 'onedream');
            ?></a>
        <?php if ($onedream_fb || $onedream_twitter || $onedream_in || $onedream_glplus || $onedream_phone || $onedream_address) { ?>
            <div class="header-top">
                <div class="container">
                    <div class="row"> 
                        <div class="col-sm-4"> 
                            <div class="social-icons">    
                                <?php if (get_theme_mod('onedream_fb')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('onedream_fb')); ?>" target="_blank" class="fa fa-facebook fa-1x" title="<?php esc_attr_e('Facebook', 'onedream'); ?>"></a>
                                <?php } ?>

                                <?php if (get_theme_mod('onedream_twitter')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('onedream_twitter')); ?>" target="_blank" class="fa fa-twitter fa-1x" title="<?php esc_attr_e('twitter', 'onedream'); ?>"></a>
                                <?php } ?>

                                <?php if (get_theme_mod('onedream_glplus')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('onedream_glplus')); ?>" target="_blank" class="fa fa-google-plus fa-1x" title="<?php esc_attr_e('google-plus', 'onedream'); ?>"></a>
                                <?php } ?>

                                <?php if (get_theme_mod('onedream_in')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('onedream_in')); ?>" target="_blank" class="fa fa-linkedin fa-1x" title="<?php esc_attr_e('linkedin', 'onedream'); ?>"></a>
                                <?php } ?>


                            </div> <!--social-icons-->
                        </div><!--col-sm-4-->
                        <div class="col-sm-8 rightsphone">
                            <?php if (get_theme_mod('onedream_phone')) { ?>
                                <i class="fa fa-phone"></i> <span class="phno"><?php echo esc_html($onedream_phone); ?></span>
                            <?php } ?>                    

                            <?php if (get_theme_mod('onedream_address')) { ?>
                                <i class="fa fa-map-marker"></i><?php echo esc_html($onedream_address); ?></div>
                        <?php } ?>         
                        <div class="clear"></div>
                    </div><!--col-sm-8 rightsphone-->        
                </div><!--row -->
            </div><!--container-->
        </div><!-- header-top -->
    <?php } ?>

    <section id="main_navigation">
        <div class="container" >
            <div class="row">  
                <div class="col-sm-3 leftlogo">            
                    <?php if (display_header_text() == true) { ?>
                        <div class="logotxt">
                            <h1><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
                            <p><?php bloginfo('description'); ?></p>
                        </div>
                    <?php } ?>
                </div> <!--col-sm-3--> 

                <div class="main-navigation-inner col-sm-9 rightmenu">
                    <div class="toggle">
                        <a class="togglemenu" href="#"><?php esc_html_e('Menu', 'onedream'); ?></a>
                    </div><!-- toggle --> 
                    <div class="sitenav">
                        <div class="nav">
                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'primary'
                            ));
                            ?>
                        </div>
                    </div><!-- site-nav -->
                </div><!--<div class="row">-->
            </div><!--main-navigation-->
        </div><!--container-->
    </section><!--main_navigation-->

    <?php
    $slidervariable = array();
    for ($k = 1; $k <= 3; $k++) {
        ?>
        <?php $banner_id  = absint(get_theme_mod('banner' . $k, true)); ?>
        <?php $slidequery = new WP_query('page_id=' . $banner_id); ?>
        <?php
        if ($slidequery->have_posts() && $banner_id > 0) :
            while ($slidequery->have_posts()) : $slidequery->the_post();
                $thumbnail_id     = get_post_thumbnail_id($post->ID);
                $alt              = esc_html(get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true));
                $image            = esc_url(get_the_post_thumbnail_url($post->ID, 'onedream-home-banner-size'));
                $title            = esc_html(get_the_title($post->ID));
                $my_postid        = $post->ID; //This is page id or post id
                $content_post     = get_post($my_postid);
                $content          = esc_html($content_post->post_content);
                $slidervariable[] = array('pageid' => $post->ID, 'bannerimage' => $image, 'alt' => $alt, 'slider_title' => $title, 'slider_content' => $content);
            endwhile;
            wp_reset_postdata();
        endif;
        ?>

    <?php } ?>
    <?php $slidervariable_count = count($slidervariable); ?>
    <?php if ($slidervariable_count > 0) { ?>
        <section id="banner" class="container-fluid">
            <div class="row" >
                <div class="col-sm-12">
                    <div class="row" >
                        <?php if (is_front_page() || is_home()) { ?>
                            <?php if (get_header_image()) { ?>
                                <img class="img-responsive" src="<?php header_image(); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" >
                            <?php } else { ?>

                                <div id="myCarousel" class="carousel slide" data-ride="carousel">
                                    <!-- Indicators -->
                                    <ol class="carousel-indicators hidden-xs">
                                        <?php
                                        for ($i = 0; $i < $slidervariable_count; $i++) {
                                            ?>
                                            <?php
                                            if ($i == 0) {
                                                $active = 'active';
                                            } else {
                                                $active = '';
                                            }
                                            ?>
                                            <li data-target="#myCarousel" data-slide-to="<?php echo esc_attr($i); ?>" class="<?php echo esc_attr($active); ?>"></li>      
                                        <?php } ?>
                                    </ol>

                                    <!-- Wrapper for slides -->
                                    <div class="carousel-inner">
                                        <?php $number = 1; ?>
                                        <?php foreach ($slidervariable as $slidervariables) { ?>
                                            <?php
                                            if ($number == 1) {
                                                $statis = "active";
                                            } else {
                                                $statis = "";
                                            }
                                            ?>

                                            <div class="item <?php echo esc_attr($statis); ?>">
                                                <img class="img-responsive" src="<?php echo esc_url($slidervariables['bannerimage']); ?>" title="<?php echo esc_attr($slidervariables['alt']); ?>">
                                                <div class="carousel-caption hidden-xs">
                                                    <h3><?php echo esc_html($slidervariables['slider_title']); ?></h3>
                                                    <p><?php echo esc_html($slidervariables['slider_content']); ?></p>
                                                </div>
                                            </div>
                                            <?php
                                            $number++;
                                        }
                                        ?>
                                    </div><!--carousel-inner-->

                                    <?php if ($banner_id > 0) { ?>
                                        <!-- Left and right controls -->
                                        <a class="left carousel-control" href="#myCarousel" data-slide="prev">
                                            <span class="glyphicon glyphicon-chevron-left"></span>
                                            <span class="sr-only"><?php echo esc_html__('Previous', 'onedream') ?></span>
                                        </a>
                                        <a class="right carousel-control" href="#myCarousel" data-slide="next">
                                            <span class="glyphicon glyphicon-chevron-right"></span>
                                            <span class="sr-only"><?php echo esc_html__('Next', 'onedream') ?></span>
                                        </a>
                                    <?php } ?>
                                </div><!--myCarousel-->
                            <?php } ?>
                        <?php } ?>
                    </div><!--row-->
                </div><!--col-sm-12-->
            </div><!--row-->
        </section><!--banner-->
    <?php } else { ?>
        <section id="banner" class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="row">
                        <?php if (is_front_page() || is_home()) { ?>
                            <?php if (get_header_image()) { ?>
                                <div class="homeslider">
                                    <img class="img-responsive" src="<?php header_image(); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" >
                                </div>  <!--homeslider-->
                            <?php } ?>
                        <?php } ?>

                    </div><!--row-->
                </div><!--col-sm-12-->
            </div><!--row-->
        </section><!--banner-->
    <?php } ?>

    <?php if (!is_front_page() && !is_home()) { ?>
        <section id="banner" class="container-fluid">
            <div class="row" >
                <div class="col-sm-12">
                    <div class="row" >
                        <img class="img-responsive" src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/images/innerpage.jpg">
                    </div>
                </div>
            </div>
        </section>    <!--banner-->
    <?php } ?>

    <?php if (is_front_page() && !is_home()) { ?>
        <div class="container">
            <?php get_template_part('template', 'home'); ?>
        </div>
    <?php }
    ?>