<?php

/**
 * @package OneDream
 */
require_once get_template_directory() . "/lib/onedream_customizer.php";

function onedream_customize_controls_js() {
    $theme = wp_get_theme();
    wp_enqueue_script('onedream-customizer-section-pro-jquery', get_template_directory_uri() . '/lib/onedream-customize-controls.js', array('customize-controls'), $theme->get('Version'), true);
    wp_enqueue_style('onedream-customizer-section-pro', get_template_directory_uri() . '/lib/onedream-customize-controls.css', $theme->get('Version'));
}

add_action('customize_controls_enqueue_scripts', 'onedream_customize_controls_js');

function onedream_style_js() {
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/bootstrap/css/bootstrap.css');
    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/css/font-awesome.css');
    wp_enqueue_style('onedream-basic-style', get_stylesheet_uri());
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/bootstrap/js/bootstrap.js', array('jquery'));
    wp_enqueue_script('onedream-toggle-jquery', get_template_directory_uri() . '/js/onedream-toggle.js', array('jquery'));
}

add_action('wp_enqueue_scripts', 'onedream_style_js');

if (!function_exists('onedream_setup')) :

    function onedream_setup() {
        add_theme_support('automatic-feed-links');
        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        $defaults = array(
            'default-image'      => get_template_directory_uri() . '/images/slider1.jpg',
            'default-text-color' => 'ffffff',
            'width'              => 1400,
            'height'             => 500,
            'uploads'            => true,
            'wp-head-callback'   => 'onedream_header_style',
        );
        add_theme_support('custom-header', $defaults);

        add_theme_support('title-tag');
        register_nav_menus(array(
            'primary' => esc_html__('Primary Menu', 'onedream'),
            'footer'  => esc_html__('Footer Menu', 'onedream'),
        ));
        add_theme_support('custom-background', array(
            'default-color' => 'ffffff'
        ));

        if (!isset($content_width))
            $content_width = 900;

        add_image_size('onedream-home-banner-size', 1600, 550, true);
        add_image_size('onedream-home-box-size', 400, 250, true);
    }

endif; // onedream_setup
add_action('after_setup_theme', 'onedream_setup');

//logo header style
function onedream_header_style() {
    $onedream_header_text_color = get_header_textcolor();
    if (get_theme_support('custom-header', 'default-text-color') === $onedream_header_text_color) {
        return;
    }
    echo '<style id="fbizz-consult-lite-custom-header-styles" type="text/css">';
    if ('blank' !== $onedream_header_text_color) {
        echo '.logotxt, .logotxt a
			 {
				color: #' . esc_attr($onedream_header_text_color) . '
			}';
    }
    echo '</style>';
}

function onedream_widgets_init() {

    register_sidebar(array(
        'name'          => esc_html__('Sidebar', 'onedream'),
        'description'   => esc_html__('Appears on sidebar', 'onedream'),
        'id'            => 'sidebar-1',
        'before_widget' => '',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3><aside id="" class="widget">',
        'after_widget'  => '</aside>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer 1', 'onedream'),
        'description'   => esc_html__('Appears on sidebar', 'onedream'),
        'id'            => 'footer-1',
        'before_widget' => '',
        'before_title'  => '<h1 class="widget-title">',
        'after_title'   => '</h1><aside id="" class="widget">',
        'after_widget'  => '</aside>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer 2', 'onedream'),
        'description'   => esc_html__('Appears on sidebar', 'onedream'),
        'id'            => 'footer-2',
        'before_widget' => '',
        'before_title'  => '<h1 class="widget-title">',
        'after_title'   => '</h1><aside id="" class="widget">',
        'after_widget'  => '</aside>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer 3', 'onedream'),
        'description'   => esc_html__('Appears on sidebar', 'onedream'),
        'id'            => 'footer-3',
        'before_widget' => '',
        'before_title'  => '<h1 class="widget-title">',
        'after_title'   => '</h1><aside id="" class="widget">',
        'after_widget'  => '</aside>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer 4', 'onedream'),
        'description'   => esc_html__('Appears on sidebar', 'onedream'),
        'id'            => 'footer-4',
        'before_widget' => '',
        'before_title'  => '<h1 class="widget-title">',
        'after_title'   => '</h1><aside id="" class="widget">',
        'after_widget'  => '</aside>',
    ));
}

add_action('widgets_init', 'onedream_widgets_init');

function onedream_get_excerpt($postid, $post_count_size) {
    $excerpt = get_post_field('post_content', $postid);
    $excerpt = preg_replace(" ([.*?])", '', $excerpt);
    $excerpt = strip_shortcodes($excerpt);
    $excerpt = strip_tags($excerpt);
    $excerpt = substr($excerpt, 0, $post_count_size);
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
    return $excerpt;
}

function onedream_skip_link_focus_fix() {
    // The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
    ?>
    <script>
        /(trident|msie)/i.test(navigator.userAgent) && document.getElementById && window.addEventListener && window.addEventListener("hashchange", function () {
            var t, e = location.hash.substring(1);
            /^[A-z0-9_-]+$/.test(e) && (t = document.getElementById(e)) && (/^(?:a|select|input|button|textarea)$/i.test(t.tagName) || (t.tabIndex = -1), t.focus())
        }, !1);
    </script>
    <!-- menu dropdown accessibility -->
    <script type="text/javascript">

        jQuery(document).ready(function () {
            jQuery(".nav").onedreamAccessibleDropDown();
        });

        jQuery.fn.onedreamAccessibleDropDown = function () {
            var el = jQuery(this);

            /* Make dropdown menus keyboard accessible */

            jQuery("a", el).focus(function () {
                jQuery(this).parents("li").addClass("hover");
            }).blur(function () {
                jQuery(this).parents("li").removeClass("hover");
            });
        }
    </script>
    <?php

}
add_action('wp_print_footer_scripts', 'onedream_skip_link_focus_fix');
