<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'onedot_enqueue_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function onedot_enqueue_styles() {
        wp_enqueue_style( 'blogbell-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'onedot-style', get_stylesheet_directory_uri() . '/style.css', array( 'blogbell-style-parent' ), '1.0.0' );
    }
endif;
add_action( 'wp_enqueue_scripts', 'onedot_enqueue_styles', 99 );

if ( ! function_exists( 'onedot_get_default_theme_options' ) ) :

    /**
     * Get default theme options.
     *
     * @since 1.0.0
     *
     * @return array Default theme options.
     */
function onedot_get_default_theme_options() {

    $theme_data = wp_get_theme();
    $defaults = array();


    // Featured Slider Section
    $defaults['disable_featured-slider_section']    = false;
    $defaults['disable_white_overlay']      = false;
    // About Section
    $defaults['disable_about_section']  = false;
    $defaults['latest_posts_title']         = esc_html__( 'Latest Posts', 'onedot' );
    $defaults['pagination_type']        = 'default';

    // Blog Section
    $defaults['disable_blog_section']       = false;    
    $defaults['blog_title']                 = esc_html__( 'Featured Post', 'onedot' ); 

    
    //General Section
    $defaults['readmore_text']              = esc_html__('Read More','onedot');
    $defaults['excerpt_length']             = 40;
    $defaults['layout_options_blog']            = 'right-sidebar';
    $defaults['layout_options_archive']         = 'right-sidebar';
    $defaults['layout_options_page']            = 'right-sidebar';  
    $defaults['layout_options_single']          = 'right-sidebar';  

    //Footer section        
    $defaults['copyright_text']             = esc_html__( 'Copyright &copy; All rights reserved.', 'onedot' );

    return $defaults;
}
endif;
add_filter( 'blogbell_filter_default_theme_options', 'onedot_get_default_theme_options', 99 );
