<?php
/**
 * WooCommerce Compatibility File
 *
 * @link https://woocommerce.com/
 *
 * @package One_Hive
 */

function one_hive_woocommerce_setup() {
  add_theme_support( 'woocommerce' );
  add_theme_support( 'wc-product-gallery-zoom' );
  add_theme_support( 'wc-product-gallery-lightbox' );
  add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'one_hive_woocommerce_setup' );

/**
 * Add 'woocommerce-active' class to the body tag.
 *
 * @param  array $classes CSS classes applied to the body tag.
 * @return array $classes modified to include 'woocommerce-active' class.
 */
function one_hive_woocommerce_active_body_class( $classes ) {
	$classes[] = 'woocommerce-active';

	return $classes;
}
add_filter( 'body_class', 'one_hive_woocommerce_active_body_class' );

/**
 * Products per page.
 *
 * @return integer number of products.
 */
function one_hive_woocommerce_products_per_page() {
	return 12;
}
add_filter( 'loop_shop_per_page', 'one_hive_woocommerce_products_per_page' );

/**
 * Product gallery thumnbail columns.
 *
 * @return integer number of columns.
 */
function one_hive_woocommerce_thumbnail_columns() {
	return 4;
}
add_filter( 'woocommerce_product_thumbnails_columns', 'one_hive_woocommerce_thumbnail_columns' );

/**
 * Default loop columns on product archives.
 *
 * @return integer products per row.
 */
function one_hive_woocommerce_loop_columns() {
	$sidebar_position = one_hive_get_option( 'one_hive_global_sidebar_choice' );
	if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
		return 3;
	} else {
		return 4;
	}
}
add_filter( 'loop_shop_columns', 'one_hive_woocommerce_loop_columns' );

/**
 * Related Products Args.
 *
 * @param array $args related products args.
 * @return array $args related products args.
 */
function one_hive_woocommerce_related_products_args( $args ) {
	$sidebar_position = one_hive_get_option( 'one_hive_global_sidebar_choice' );
	if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
		$columns = 3;
	} else {
		$columns = 4;
	}
	$defaults = array(
		'posts_per_page' => $columns,
		'columns'        => $columns,
	);

	$args = wp_parse_args( $defaults, $args );

	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'one_hive_woocommerce_related_products_args' );

if ( ! function_exists( 'one_hive_woocommerce_product_columns_wrapper' ) ) {
	/**
	 * Product columns wrapper.
	 *
	 * @return  void
	 */
	function one_hive_woocommerce_product_columns_wrapper() {
		
		$columns = one_hive_woocommerce_loop_columns();
		
		echo '<div class="columns-' . absint( $columns ) . '">';
	}
}
add_action( 'woocommerce_before_shop_loop', 'one_hive_woocommerce_product_columns_wrapper', 40 );

if ( ! function_exists( 'one_hive_woocommerce_product_columns_wrapper_close' ) ) {
	/**
	 * Product columns wrapper close.
	 *
	 * @return  void
	 */
	function one_hive_woocommerce_product_columns_wrapper_close() {
		echo '</div>';
	}
}
add_action( 'woocommerce_after_shop_loop', 'one_hive_woocommerce_product_columns_wrapper_close', 40 );

/**
 * Remove default WooCommerce wrapper.
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

if ( ! function_exists( 'one_hive_woocommerce_wrapper_before' ) ) {
	/**
	 * Before Content.
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function one_hive_woocommerce_wrapper_before() {
		$sidebar_position = one_hive_get_option( 'one_hive_global_sidebar_choice' );
		?>
		<div class="single_page_main_wrapper">
	        <div class="oh_container">
	            <div id="primary" class="content-area">
	                <main id="main" class="site-main">
	                	<div class="row">
	                		<?php
			            		$class = null;
			            		if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
			            			$class = 'col-md-8 col-sm-12 col-xs-12 sticky_portion';
			            		} else {
			            			$class = 'col-md-12 col-sm-12 col-xs-12';
			            		}

			            		if( $sidebar_position == 'left' ) {
			            			get_sidebar();
			            		}
			            	?>
	                		<div class="<?php echo esc_attr( $class ); ?>">
		<?php
	}
}
add_action( 'woocommerce_before_main_content', 'one_hive_woocommerce_wrapper_before' );

if ( ! function_exists( 'one_hive_woocommerce_wrapper_after' ) ) {
	/**
	 * After Content.
	 *
	 * Closes the wrapping divs.
	 *
	 * @return void
	 */
	function one_hive_woocommerce_wrapper_after() {
		$sidebar_position = one_hive_get_option( 'one_hive_global_sidebar_choice' );
		$class = null;
		if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
			$class = 'col-md-8 col-sm-12 col-xs-12 sticky_portion';
		} else {
			$class = 'col-md-12 col-sm-12 col-xs-12';
		}
		?>
							</div>
							<?php if( $sidebar_position == 'right' ) { get_sidebar(); } ?>
						</div><!-- .row -->
					</main><!-- #main -->
				</div><!-- #primary -->
			</div>
		</div>
		<?php
	}
}
add_action( 'woocommerce_after_main_content', 'one_hive_woocommerce_wrapper_after' );

/**
 * Sample implementation of the WooCommerce Mini Cart.
 *
 * You can add the WooCommerce Mini Cart to header.php like so ...
 *
	<?php
		if ( function_exists( 'one_hive_woocommerce_header_cart' ) ) {
			one_hive_woocommerce_header_cart();
		}
	?>
 */

if ( ! function_exists( 'one_hive_woocommerce_cart_link_fragment' ) ) {
	/**
	 * Cart Fragments.
	 *
	 * Ensure cart contents update when products are added to the cart via AJAX.
	 *
	 * @param array $fragments Fragments to refresh via AJAX.
	 * @return array Fragments to refresh via AJAX.
	 */
	function one_hive_woocommerce_cart_link_fragment( $fragments ) {
		ob_start();
		one_hive_woocommerce_cart_link();
		$fragments['a.cart-contents'] = ob_get_clean();

		return $fragments;
	}
}
add_filter( 'woocommerce_add_to_cart_fragments', 'one_hive_woocommerce_cart_link_fragment' );

if ( ! function_exists( 'one_hive_woocommerce_cart_link' ) ) {
	/**
	 * Cart Link.
	 *
	 * Displayed a link to the cart including the number of items present and the cart total.
	 *
	 * @return void
	 */
	function one_hive_woocommerce_cart_link() {
		?>
		<a class="cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'one-hive' ); ?>">
			<?php
			$item_count_text = sprintf(
				/* translators: number of items in the mini cart. */
				_n( '%d item', '%d items', WC()->cart->get_cart_contents_count(), 'one-hive' ),
				WC()->cart->get_cart_contents_count()
			);
			?>
			<span class="amount"><?php echo wp_kses_data( WC()->cart->get_cart_subtotal() ); ?></span> <span class="count"><?php echo esc_html( $item_count_text ); ?></span>
		</a>
		<?php
	}
}

if ( ! function_exists( 'one_hive_woocommerce_header_cart' ) ) {
	/**
	 * Display Header Cart.
	 *
	 * @return void
	 */
	function one_hive_woocommerce_header_cart() {
		if ( is_cart() ) {
			$class = 'current-menu-item';
		} else {
			$class = '';
		}
		?>
		<ul id="site-header-cart" class="site-header-cart">
			<li class="<?php echo esc_attr( $class ); ?>">
				<?php one_hive_woocommerce_cart_link(); ?>
			</li>
			<li>
				<?php
				$instance = array(
					'title' => '',
				);

				the_widget( 'WC_Widget_Cart', $instance );
				?>
			</li>
		</ul>
		<?php
	}
}





add_action( 'init', 'woo_remove_wc_breadcrumbs' );
function woo_remove_wc_breadcrumbs() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
}


/**
 * WooCommerce display upsell product.
*/
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
if ( ! function_exists( 'one_hive_woocommerce_upsell_display' ) ) {
  function one_hive_woocommerce_upsell_display() {

      woocommerce_upsell_display( 6, 3 ); 

  }
}
add_action( 'woocommerce_after_single_product_summary', 'one_hive_woocommerce_upsell_display', 15 );


add_action( 'woocommerce_before_shop_loop', 'one_hive_woocommerce_template_loop_archive_title', 10 );

if ( ! function_exists( 'one_hive_woocommerce_template_loop_archive_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function one_hive_woocommerce_template_loop_archive_title() {
		woocommerce_breadcrumb();
	}
}

add_action( 'woocommerce_before_single_product', 'one_hive_woocommerce_template_loop_single_title', 10 );

if ( ! function_exists( 'one_hive_woocommerce_template_loop_single_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function one_hive_woocommerce_template_loop_single_title() {
		woocommerce_breadcrumb();
	}
}