<?php
/**
 * Widget - Contact Form
 *
 * @package One_Hive
 */


if ( ! class_exists( 'One_Hive_Contact_Form_Widget' ) ) :
	/**
	* Company Contact Form Widget
	*/
	class One_Hive_Contact_Form_Widget extends WP_Widget
	{

		function __construct()
		{
			$opts = array(
				'classname' => 'footer_widgets widget_contact footer_block',
				'description'	=> esc_html__( 'Displays contact form', 'one-hive' )
			);

			parent::__construct( 'widget-three', esc_html__( 'One Hive: Contact Form', 'one-hive' ), $opts );
		}

		function widget( $args, $instance ) {

			$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

			$form_shortcode = !empty( $instance['form_shortcode'] ) ? $instance['form_shortcode'] : '';

			echo $args[ 'before_widget' ];

				echo $args[ 'before_title' ];
					echo esc_html( $title );
				echo $args[ 'after_title' ];
				?>
				<div class="widget_contents_holder">
					<?php
						echo do_shortcode( $form_shortcode );
					?>
				</div><!-- .widget_contents_holder -->
				<?php				
			echo $args[ 'after_widget' ]; 
		}

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

			$instance['title'] = sanitize_text_field( $new_instance['title'] );

			$instance['form_shortcode'] = sanitize_text_field( $new_instance['form_shortcode'] );

            return $instance;
		}

		function form( $instance ) {
			$defaults = array(
				'title' => '',
                'form_shortcode' => '',
            );

            $instance = wp_parse_args( (array) $instance, $defaults );

            $company_logo = esc_url( $instance['company_logo'] );

			?>
			<p>
                <label for="<?php echo esc_attr( $this->get_field_name('title') ); ?>">
                    <strong><?php esc_html_e('Title', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name('form_shortcode') ); ?>">
                    <strong><?php esc_html_e('Form Shortcode', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('form_shortcode') ); ?>" name="<?php echo esc_attr( $this->get_field_name('form_shortcode') ); ?>" type="text" value="<?php echo esc_attr( $instance['form_shortcode'] ); ?>" />   
            </p>

			<?php			
		}
	}
endif;
