<?php
/**
 * Widget - Company Contact
 *
 * @package One_Hive
 */


if ( ! class_exists( 'One_Hive_Company_Contact_Widget' ) ) :
	/**
	* Company Contact Widget
	*/
	class One_Hive_Company_Contact_Widget extends WP_Widget
	{

		function __construct()
		{
			$opts = array(
				'classname' => 'footer_widgets widget_information footer_block',
				'description'	=> esc_html__( 'Displays contact information of company', 'one-hive' )
			);

			parent::__construct( 'widget-two', esc_html__( 'One Hive: Contact Info', 'one-hive' ), $opts );
		}

		function widget( $args, $instance ) {

			$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

			$company_phone = !empty( $instance['telephone_no'] ) ? $instance['telephone_no'] : '';

			$post_box_no = !empty( $instance['post_box_no'] ) ? $instance['post_box_no'] : '';

			$email_address = !empty( $instance['email_address'] ) ? $instance['email_address'] : ''; 

			$company_address = !empty( $instance['physical_address'] ) ? $instance['physical_address'] : '';  

			$skype_info = !empty( $instance['skype_info'] ) ? $instance['skype_info'] : '';			

			echo $args[ 'before_widget' ];

				echo $args[ 'before_title' ];
					echo esc_html( $title );
				echo $args[ 'after_title' ];
				?>
				<div class="widget_contents_holder">
                    <ul class="company_information_lists">
                    	<?php
                    		if( !empty( $company_phone ) ) :
		                    	?>
		                        <li class="company_phone">
		                        	<span>
		                        		<?php
		                        			echo esc_html( $company_phone );
		                        		?>
		                        	</span>
		                        </li><!-- .company_phone -->
		                        <?php
                        	endif;

                        	if( !empty( $post_box_no ) ) :
		                        ?>
		                        <li class="company_pobox">
		                        	<span>
		                        		<?php
		                        			echo esc_html( $post_box_no );
		                        		?>
		                        	</span>
		                        </li><!-- .company_pobox -->
		                        <?php
                        	endif;

                        	if( !empty( $email_address ) ) :
		                        ?>
		                        <li class="company_email">
		                        	<span>
		                        		<?php
		                        			echo esc_html( $email_address );
		                        		?>
		                        	</span>
		                        </li><!-- .company_email -->
		                        <?php
                        	endif;

                        	if( !empty( $company_address ) ) :
		                        ?>
		                        <li class="company_location">
		                        	<span>
		                        		<?php
		                        			echo esc_html( $company_address );
		                        		?>
		                        	</span>
		                        </li><!-- .company_location -->
		                        <?php
                        	endif;

                        	if( !empty( $skype_info ) ) :
		                        ?>
		                        <li class="company_skype">
		                        	<span>
		                        		<?php
		                        			echo esc_html( $skype_info );
		                        		?>
		                        	</span>
		                        </li><!-- .company_skype -->
		                        <?php
                        	endif;
                        ?>
                    </ul><!-- .company_information_lists -->
                </div><!-- .widget_contents_holder -->
				<?php				
			echo $args[ 'after_widget' ]; 
		}

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

			$instance['title'] = sanitize_text_field( $new_instance['title'] );

			$instance['telephone_no'] = sanitize_text_field( $new_instance['telephone_no'] );

            $instance['post_box_no'] = sanitize_text_field( $new_instance['post_box_no'] );

            $instance['email_address'] = sanitize_email( $new_instance['email_address'] );

            $instance['physical_address'] = sanitize_text_field( $new_instance['physical_address'] );

            $instance['skype_info'] = sanitize_text_field( $new_instance['skype_info'] );

            return $instance;
		}

		function form( $instance ) {
			$defaults = array(
				'title' => '',
                'telephone_no' => '',
                'post_box_no' => '',
                'email_address' => '',
                'physical_address' => '',
                'skype_info' => '',
            );

            $instance = wp_parse_args( (array) $instance, $defaults );

            $company_logo = esc_url( $instance['company_logo'] );

			?>
			<p>
                <label for="<?php echo esc_attr( $this->get_field_name('title') ); ?>">
                    <strong><?php esc_html_e('Title', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name('telephone_no') ); ?>">
                    <strong><?php esc_html_e('Telephone No', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('telephone_no') ); ?>" name="<?php echo esc_attr( $this->get_field_name('telephone_no') ); ?>" type="text" value="<?php echo esc_attr( $instance['telephone_no'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name('post_box_no') ); ?>">
                    <strong><?php esc_html_e('Post Box No', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('post_box_no') ); ?>" name="<?php echo esc_attr( $this->get_field_name('post_box_no') ); ?>" type="text" value="<?php echo esc_attr( $instance['post_box_no'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name('email_address') ); ?>">
                    <strong><?php esc_html_e('Email Address', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('email_address') ); ?>" name="<?php echo esc_attr( $this->get_field_name('email_address') ); ?>" type="email" value="<?php echo esc_attr( $instance['email_address'] ); ?>" />   
            </p>
			
			<p>
                <label for="<?php echo esc_attr( $this->get_field_name('physical_address') ); ?>">
                    <strong><?php esc_html_e('Company Address', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('physical_address') ); ?>" name="<?php echo esc_attr( $this->get_field_name('physical_address') ); ?>" type="text" value="<?php echo esc_attr( $instance['physical_address'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name('skype_info') ); ?>">
                    <strong><?php esc_html_e('Skype Info', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('skype_info') ); ?>" name="<?php echo esc_attr( $this->get_field_name('skype_info') ); ?>" type="text" value="<?php echo esc_attr( $instance['skype_info'] ); ?>" />   
            </p>

			<?php			
		}
	}
endif;
