<?php
/**
 * Widget - Company
 *
 * @package One_Hive
 */


if ( ! class_exists( 'One_Hive_About_Company_Widget' ) ) :
	/**
	* About Company Widget
	*/
	class One_Hive_About_Company_Widget extends WP_Widget
	{

		function __construct()
		{
			$opts = array(
				'classname' => 'footer_widgets footer_block',
				'description'	=> esc_html__( 'Displays short information about company', 'one-hive' )
			);

			parent::__construct( 'widget-one', esc_html__( 'One Hive: About', 'one-hive' ), $opts );
		}

		function widget( $args, $instance ) {

			$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
			
			$company_logo        = !empty( $instance['company_logo'] ) ? $instance['company_logo'] : ''; 

            $company_info    	= !empty( $instance['company_info'] ) ? $instance['company_info'] : '';

            $facebook_link = !empty( $instance['facebook_link'] ) ? $instance['facebook_link'] : '';

			$twitter_link = !empty( $instance['twitter_link'] ) ? $instance['twitter_link'] : '';

			$google_plus_link = !empty( $instance['google_plus_link'] ) ? $instance['google_plus_link'] : '';

			$linkedin_link = !empty( $instance['linkedin_link'] ) ? $instance['linkedin_link'] : '';

			$instagram_link = !empty( $instance['instagram_link'] ) ? $instance['instagram_link'] : '';

			echo $args[ 'before_widget' ];

				echo $args[ 'before_title' ];
					echo esc_html( $title );
				echo $args[ 'after_title' ];
				?>
				<div class="widget_contents_holder">
					<?php
						if( !empty( $company_logo ) ) :
							?>
							<div class="site_branding">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<img src="<?php echo esc_url( $company_logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>">
								</a>
							</div><!-- .site_branding -->
							<?php
						endif;

						if( !empty( $company_info ) ) :
							?>
							<div class="site_about_footer_text">
								<?php
									echo wp_kses_post( $company_info );
								?>
							</div><!-- .site_about_footer_text -->
							<?php
						endif;
					?>
					<div class="social_footer">
						<ul class="footer_social_icon_list">
							<?php
								if( !empty( $facebook_link ) ) :
									?>
		                            <li>
		                            	<a href="<?php echo esc_url( $facebook_link ); ?>" target="_blank">
		                            		<i class="fa fa-facebook" aria-hidden="true"></i>
		                            	</a>
		                            </li>
		                            <?php
                            	endif;

                            	if( !empty( $twitter_link ) ) :
		                            ?>
		                            <li>
		                            	<a href="<?php echo esc_url( $twitter_link ); ?>" target="_blank">
		                            		<i class="fa fa-twitter" aria-hidden="true"></i>
		                            	</a>
		                            </li>
		                            <?php
                            	endif;

                            	if( !empty( $google_plus_link ) ) :
		                            ?>
		                            <li>
		                            	<a href="<?php echo esc_url( $google_plus_link ); ?>" target="_blank">
		                            		<i class="fa fa-google-plus" aria-hidden="true"></i>
		                            	</a>
		                            </li>
		                            <?php
                            	endif;

                            	if( !empty( $linkedin_link ) ) :
		                            ?>
		                            <li>
		                            	<a href="<?php echo esc_url( $linkedin_link ); ?>" target="_blank">
		                            		<i class="fa fa-linkedin-square" aria-hidden="true"></i>
		                            	</a>
		                            </li>
		                            <?php
                            	endif;

                            	if( !empty( $instagram_link ) ) :
		                            ?>
		                            <li>
		                            	<a href="<?php echo esc_url( $instagram_link ); ?>" target="_blank">
		                            		<i class="fa fa-instagram" aria-hidden="true"></i>
		                            	</a>
		                            </li>
		                            <?php
                            	endif;
                            ?>                            
                        </ul><!-- .footer_social_icon_list -->
                    </div><!-- .social_footer -->
                </div><!-- .widget_contents_holder -->
				<?php
				
			echo $args[ 'after_widget' ]; 
		}

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

			$instance['title'] = sanitize_text_field( $new_instance['title'] );

			$instance['company_logo'] = esc_url_raw( $new_instance['company_logo'] );

            $instance['company_info'] = sanitize_text_field( $new_instance['company_info'] );

            $instance['facebook_link'] = esc_url_raw( $new_instance['facebook_link'] );

            $instance['twitter_link'] = esc_url_raw( $new_instance['twitter_link'] );

            $instance['google_plus_link'] = esc_url_raw( $new_instance['google_plus_link'] );

            $instance['linkedin_link'] = esc_url_raw( $new_instance['linkedin_link'] );

            $instance['instagram_link'] = esc_url_raw( $new_instance['instagram_link'] );

            return $instance;
		}

		function form( $instance ) {
			$defaults = array(
				'title' => '',
                'company_logo' => '',
                'company_info' => '',
                'facebook_link' => '',
                'twitter_link' => '',
                'google_plus_link' => '',
                'linkedin_link' => '',
                'instagram_link' => '',
            );

            $instance = wp_parse_args( (array) $instance, $defaults );

            $company_logo = $instance['company_logo'];

			?>
			<p>
                <label for="<?php echo esc_attr( $this->get_field_name('title') ); ?>">
                    <strong><?php esc_html_e('Title', 'one-hive'); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />   
            </p>

			<p>
                <label for="<?php echo esc_attr($this->get_field_id('company_logo')); ?>">
                    <strong><?php esc_html_e('Add Logo', 'one-hive'); ?></strong>
                </label>
                <br/>
                <?php
                if (!empty($company_logo)) :
                    echo '<img class="custom_media_image widefat" src="' . esc_url( $company_logo ) . '"/><br />';
                endif;
                ?>
                <input type="text" class="widefat custom_media_url"
                       name="<?php echo esc_attr($this->get_field_name('company_logo')); ?>"
                       id="<?php echo esc_attr($this->get_field_id('company_logo')); ?>" value="<?php echo esc_url( $company_logo ); ?>">
                <input type="button" class="button button-primary custom_media_button" id="custom_media_button"
                       name="<?php echo esc_attr($this->get_field_name('company_logo')); ?>"
                       value="<?php esc_attr_e('Upload', 'one-hive') ?>"/>
            </p>

			<p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'company_info' ) ); ?>">
                    <strong><?php esc_html_e( 'Short Company Detail', 'one-hive' ); ?></strong>
                </label>
                <textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'company_info' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'company_info' ) ); ?>" cols="30" rows="10">
                	<?php echo esc_html( $instance['company_info'] ); ?>
                </textarea>
            </p>
			
			<p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'facebook_link' ) ); ?>">
                    <strong><?php esc_html_e( 'Facebook Link', 'one-hive' ); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'facebook_link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'facebook_link' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['facebook_link'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'twitter_link' ) ); ?>">
                    <strong><?php esc_html_e( 'Twitter Link', 'one-hive' ); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'twitter_link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'twitter_link' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['twitter_link'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'google_plus_link' ) ); ?>">
                    <strong><?php esc_html_e( 'Google Plus', 'one-hive' ); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'google_plus_link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'google_plus_link' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['google_plus_link'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'linkedin_link' ) ); ?>">
                    <strong><?php esc_html_e( 'Linkedin Link', 'one-hive' ); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'linkedin_link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'linkedin_link' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['linkedin_link'] ); ?>" />   
            </p>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'instagram_link' ) ); ?>">
                    <strong><?php esc_html_e( 'Instagram Link', 'one-hive' ); ?></strong>
                </label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'instagram_link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'instagram_link' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['instagram_link'] ); ?>" />   
            </p>
			<?php			
		}
	}
endif;
