<?php
/**
 * One Hive Widget Initialization and Registration
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package One_Hive
 */

require_once trailingslashit( get_template_directory() ) . '/themebeez/widget/widgets/widget-company.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/widget/widgets/widget-contact.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/widget/widgets/widget-form.php';

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function one_hive_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Widget Area', 'one-hive' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'one-hive' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-info">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area', 'one-hive' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Add widgets here.', 'one-hive' ),
		'before_widget' => '<div class="col-md-4 col-sm-12 col-xs-12"><div id="%1$s" class="widget %2$s"><div class="widget-info">',
		'after_widget'  => '</div></div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Map Widget Area', 'one-hive' ),
		'id'            => 'sidebar-3',
		'description'   => esc_html__( 'Add map here.', 'one-hive' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-info">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_widget( 'One_Hive_About_Company_Widget' );

	register_widget( 'One_Hive_Company_Contact_Widget' );

	register_widget( 'One_Hive_Contact_Form_Widget' );
}
add_action( 'widgets_init', 'one_hive_widgets_init' );


/**
 * Enqueue Scripts and Styles In Admin Backend
 */
if ( ! function_exists( 'one_hive_admin_scripts' ) ) {

    function one_hive_admin_scripts( $hook ) {

        if ( 'widgets.php' == $hook || is_admin() ) {

        	wp_enqueue_script( 'media-upload' );

			wp_enqueue_media();

			wp_enqueue_style( 'one-hive-admin-custom', get_template_directory_uri() . '/themebeez/widget/assets/css/admin.custom.css' );

			wp_enqueue_script( 'one-hive-admin-custom', get_template_directory_uri() . '/themebeez/widget/assets/js/admin.custom.js', array( 'jquery' ), '1.0.0' );
		}
    }
}
add_action('admin_enqueue_scripts', 'one_hive_admin_scripts');

