<?php
/**
 * One Hive Scripts Enqueing
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package One_Hive
 */

/**
 * Enqueue scripts and styles.
 */
function one_hive_scripts() {
	wp_enqueue_style( 'one-hive-style', get_stylesheet_uri() );

	wp_enqueue_style( 'one-hive-font', one_hive_fonts_url() );

	wp_enqueue_style( 'one-hive-main', get_template_directory_uri() . '/themebeez/assets/dist/css/main.min.css'  );

	wp_enqueue_script( 'one-hive-navigation', get_template_directory_uri() . '/themebeez/core/js/navigation.js', array(), '1.0.0', true );

	wp_enqueue_script( 'one-hive-skip-link-focus-fix', get_template_directory_uri() . '/themebeez/core/js/skip-link-focus-fix.js', array(), '1.0.0', true );

	wp_enqueue_script( 'one-hive-bundle', get_template_directory_uri() . '/themebeez/assets/dist/js/bundle.min.js', array('jquery'), '1.0.0', true );


	//wp_enqueue_script( 'one-hive-script', get_template_directory_uri() . '/themebeez/assets/dist/js/script.js', array('jquery'), '1.0.0', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'one_hive_scripts' );