<?php
/**
 * One Hive Hook Functions
 *
 * @package One_Hive
 */


/*
 * Hook - Enable Home Page
 */
if( ! function_exists( 'one_hive_enable_home_page_action' ) ) :
    /**
     * Enable Home Page Action
     *
     * @since 1.0.0
     */
    function one_hive_enable_home_page_action() {

        $enable_front_page = one_hive_get_option( 'one_hive_active_home_page' );

        if( 1 != $enable_front_page ){

            if ( 'posts' == get_option( 'show_on_front' ) ) {
                    include( get_home_template() );
            }
               else {
                    include( get_page_template() );
            }
        }
    }
endif;
add_action( 'one_hive_enable_home_page', 'one_hive_enable_home_page_action', 10 );


/*
 * Hook - Breadcrumb
 */
if( ! function_exists( 'one_hive_breadcrumb_action' ) ) :
    /**
     * Breadcrumb Action
     *
     * @since 1.0.0
     */
    function one_hive_breadcrumb_action() {
        $taxonomy = array( 'one_hive_project' => 'one_hive_project_cat' );
        // if( class_exists( 'Woocommerce' ) ) {
        //     $taxonomy['product'] = 'product_cat';
        // }
        ?>
        <div class="breadcrumb">
            <?php
                $breadcrumb_args = array(
                    'show_browse' => false,
                    'post_taxonomy' => $taxonomy,
                );
                one_hive_breadcrumb_trail( $breadcrumb_args );
            ?>
        </div><!-- .breadcrumb -->
        <?php
    }
endif;
add_action( 'one_hive_breadcrumb', 'one_hive_breadcrumb_action', 10 );

/*
 * Hook - Pagination
 */
if( ! function_exists( 'one_hive_pagination_action' ) ) :
    /**
     * Pagination Action
     *
     * @since 1.0.0
     */
    function one_hive_pagination_action() {
        ?>
        <?php
                    the_posts_pagination( 
                        array(
                            'mid_size'  => 2,
                            'prev_text' => esc_html__( '&laquo;', 'one-hive' ),
                            'next_text' => esc_html__( '&raquo;', 'one-hive' ),
                        ) 
                    );
                ?>
        <?php
    }
endif;
add_action( 'one_hive_pagination', 'one_hive_pagination_action', 10 );


/*
 * Hook - Credit Text
 */
if( ! function_exists( 'one_hive_footer_credit_action' ) ) :
    /**
     * Footer Credit Action
     *
     * @since 1.0.0
     */
    function one_hive_footer_credit_action() {
        ?>
        <div class="col-md-6 col-sm-12 col-xs-12">
            <p class="text-right">
                <?php
                    /* translators: theme credit info */
                    printf( esc_html__( '%1$s Theme by %2$s. Powered by %3$s.', 'one-hive' ), 'One Hive', '<a href="' . esc_url( 'https://themebeez.com' ) . '" rel="designer">Themebeez</a>', '<a href="' . esc_url( 'https://wordpress.org' ) . '">WordPress</a>' );
                ?>
            </p><!-- .text-right -->
        </div><!-- .col-* -->
        <?php
    }
endif;
add_action( 'one_hive_footer_credit', 'one_hive_footer_credit_action', 10 );