<?php
/**
 * One Hive Hepler Functions
 *
 * @package One_Hive
 */

/**
 * Funtion To Get Google Fonts
 */
if ( !function_exists( 'one_hive_fonts_url' ) ) :

    /**
     * Return Font's URL.
     *
     * @since 1.0.0
     * @return string Fonts URL.
     */
    function one_hive_fonts_url()
    {

        $fonts_url = '';
        $fonts     = array();
        $subsets   = 'latin,latin-ext';


         /* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */
         
        if ('off' !== _x('on', 'Poppins font: on or off', 'one-hive')) {
            $fonts[] = 'Poppins:400,400i,500,500i,600,700,700i';
        }

        /* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */

        if ('off' !== _x('on', 'Montserrat font: on or off', 'one-hive')) {
            $fonts[] = 'Montserrat:400,400i,500,500i,600,600i,700,700i';
        }

        if ( $fonts ) {
            $fonts_url = add_query_arg( array(
                'family' => urlencode( implode( '|', $fonts ) ),
                'subset' => urlencode( $subsets ),
            ), '//fonts.googleapis.com/css' );
        }

        return $fonts_url;
    }
endif;

/**
 * Fallback For Main Navigation Menu
*/
if ( !function_exists( 'one_hive_navigation_fallback' ) ) :

    function one_hive_navigation_fallback() {
        ?>
        <ul id="oh_mainmenu" class="clearfix">
            <li>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'one-hive' ); ?></a>
            </li>
            <?php wp_list_pages( array( 'title_li' => '', 'depth' => 1, 'number' => 5 ) ); ?>
            <li>
                <a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ); ?>" title="<?php esc_attr_e( 'Add Menu Item', 'one-hive' ); ?>"><?php esc_html_e( 'Add menu item', 'one-hive' ); ?></a>
            </li>
        </ul>
        <?php    
    }

endif;


/*
 * Hook - Plugin Recommendation
 */
if ( ! function_exists( 'one_hive_recommended_plugins' ) ) :
    /**
     * Recommend plugins.
     *
     * @since 1.0.0
     */
    function one_hive_recommended_plugins() {

        $plugins = array(
            array(
                'name'     => esc_html__( 'Themebeez Toolkit', 'one-hive' ),
                'slug'     => 'themebeez-toolkit',
                'required' => false,
            ),
            array(
                'name'     => esc_html__( 'Contact Form 7', 'one-hive' ),
                'slug'     => 'contact-form-7',
                'required' => false,
            ),
        );

        tgmpa( $plugins );
    }

endif;
add_action( 'tgmpa_register', 'one_hive_recommended_plugins' );