<?php
/**
 * One Hive Filter Functions
 *
 * @package One_Hive
 */

/**
 * Filters For Excerpt 
 *
 */
if( !function_exists( 'one_hive_excerpt_more' ) ) :
	/*
	 * Excerpt More
	 */
	function one_hive_excerpt_more( $more ) {

		if ( is_admin() ) {
			return $more;
		}

		return '';

	}
endif;
add_filter( 'excerpt_more', 'one_hive_excerpt_more' );


if( !function_exists( 'one_hive_excerpt_length' ) ) :
	/*
	 * Excerpt More
	 */
	function one_hive_excerpt_length( $length ) {

		if( is_admin() ) {
			return $length;
		}

		$excerpt_length = one_hive_get_option( 'one_hive_archive_excerpt_length' );

		if ( absint( $excerpt_length ) > 0 ) {
			$excerpt_length = absint( $excerpt_length );
		}

		return apply_filters( 'one_hive_filter_excerpt_length', $excerpt_length );

	}
endif;
add_filter( 'excerpt_length', 'one_hive_excerpt_length' );


/**
 * Filters For Archive 
 *
 */
if( !function_exists( 'one_hive_archive_title' ) ) {
	/*
	 * Archive Title
	 */
	function one_hive_archive_title( $title ) { 

		if( is_admin() ) {
			return $title;
		}

		$enable_archive_type = one_hive_get_option( 'one_hive_archive_enable_archive_type' );

		if( $enable_archive_type != 1 ) {

			if ( is_category() ) {

		        $title = single_cat_title( '', false );

		    } elseif ( is_tag() ) {

		        $title = single_tag_title( '', false );

		    } elseif ( is_author() ) {

		        $title = '<span class="vcard">' . get_the_author() . '</span>';

		    } elseif ( is_year() ) {

		        $title = get_the_date( _x( 'Y', 'yearly archives date format', 'one-hive' ) );

		    } elseif ( is_month() ) {

		        $title = get_the_date( _x( 'F Y', 'monthly archives date format', 'one-hive' ) );

		    } elseif ( is_day() ) {

		        $title = get_the_date( _x( 'F j, Y', 'daily archives date format', 'one-hive' ) );

		    } elseif ( is_tax( 'post_format' ) ) {

		        if ( is_tax( 'post_format', 'post-format-aside' ) ) {

		            $title = _x( 'Asides', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {

		            $title = _x( 'Galleries', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-image' ) ) {

		            $title = _x( 'Images', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-video' ) ) {

		            $title = _x( 'Videos', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {

		            $title = _x( 'Quotes', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-link' ) ) {

		            $title = _x( 'Links', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-status' ) ) {

		            $title = _x( 'Statuses', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {

		            $title = _x( 'Audio', 'post format archive title', 'one-hive' );

		        } elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {

		            $title = _x( 'Chats', 'post format archive title', 'one-hive' );

		        }

		    } elseif ( is_post_type_archive() ) {

		        $title = post_type_archive_title( '', false );

		    } elseif ( is_tax() ) {

		        $title = single_term_title( '', false );

		    } else {

		        $title = esc_html__( 'Archives', 'one-hive' );

		    }

		    return $title;
		} else {
			return $title;
		}

	}
	
}
add_filter( 'get_the_archive_title', 'one_hive_archive_title' );