<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('list_box'); ?> >
	<div class="row">
		<?php
			if( has_post_thumbnail() ) :
				?>
				<div class="col-md-5 col-sm-5 col-xs-12">			
					<div class="list_fimage">
						<?php
							the_post_thumbnail( 'one-hive-thumbnail-1', array( 'alt' => the_title_attribute( array( 'echo' => false ) ), 'class' => 'img-responsive' ) );
						?>
					</div><!-- .list_fimage -->
				</div><!-- .col-* -->
				<?php
			endif;
		?>
		<div class="col-md-7 col-sm-7 col-xs-12">
			<div class="list_details_outer">
				<div class="list_title">
					<h3>
						<a href="<?php the_permalink(); ?>">
							<?php
								the_title();
							?>
						</a>
					</h3>
				</div><!-- .list title -->
				<?php
					if( get_post_type() == 'post' ) :
						?>
						<div class="list_meta">
							<div class="author_meta">
								<?php
									one_hive_get_post_author();
								?>
							</div>
							<div class="posted_meta">
								<?php
									one_hive_get_post_date();
								?>
							</div><!-- .posted_meta -->
						</div><!-- .list_meta -->
						<?php
					endif;
				?>
				<div class="list_excerpt">
					<?php
						the_excerpt();
					?>
				</div><!-- .list_excerpt -->
			</div><!-- .list_details_outer -->
		</div><!-- .col-* -->
	</div><!-- .row -->
</article><!-- #post-<?php the_ID(); ?> -->

